/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.jai;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TiledImage;
import javax.media.jai.WarpPolynomial;
import javax.media.jai.operator.ClampDescriptor;
import javax.media.jai.operator.CompositeDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ImageUtils;
import org.esa.beam.util.IntMap;
import org.esa.beam.util.jai.JAIDebug;
import org.esa.beam.util.jai.RectificationGrid;

public class JAIUtils {
    static final int TILE_SIZE_STEP = 64;
    static final int MIN_TILE_SIZE = 256;
    static final int MAX_TILE_SIZE = 640;

    public static void setDefaultTileCacheCapacity(int megabytes) {
        TileCache tileCache = JAI.getDefaultInstance().getTileCache();
        tileCache.memoryControl();
        tileCache.setMemoryCapacity((long)megabytes * 1024L * 1024L);
        Debug.trace("JAI tile cache capacity set to " + tileCache.getMemoryCapacity() + " bytes");
    }

    public static RenderedOp createTileFormatOp(RenderedImage img, int tileWidth, int tileHeight) {
        ImageLayout tileLayout = new ImageLayout(img);
        tileLayout.setTileWidth(tileWidth);
        tileLayout.setTileHeight(tileHeight);
        HashMap<RenderingHints.Key, ImageLayout> map = new HashMap<RenderingHints.Key, ImageLayout>();
        map.put(JAI.KEY_IMAGE_LAYOUT, tileLayout);
        RenderingHints tileHints = new RenderingHints(map);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(img);
        return JAI.create((String)"format", (ParameterBlock)pb, (RenderingHints)tileHints);
    }

    public static TiledImage createTiledImage(float[] data, int width, int height) {
        return JAIUtils.createTiledImage(new float[][]{data}, width, height, 1);
    }

    public static TiledImage createTiledImage(float[][] data, int width, int height, int numBands) {
        int length = width * height;
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)width, (int)height, (int)numBands);
        DataBufferFloat dataBuffer = new DataBufferFloat(data, length);
        Point origin = new Point(0, 0);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)origin);
        return JAIUtils.createTiledImage(raster);
    }

    public static TiledImage createTiledImage(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        TiledImage tiledImage = new TiledImage(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, sampleModel, colorModel);
        tiledImage.setData(raster);
        JAIDebug.trace("createRenderedImage.tiledImage", (RenderedImage)tiledImage);
        return tiledImage;
    }

    public static PlanarImage createPlanarImage(WritableRaster raster) {
        ColorModel cm = PlanarImage.createColorModel((SampleModel)raster.getSampleModel());
        BufferedImage bi = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }

    public static RenderedOp createColorToGrayOp(RenderedImage src) {
        if (src.getColorModel().getNumColorComponents() != 3) {
            throw new IllegalArgumentException("a minimum of three bands expected");
        }
        double[][] matrix = new double[][]{{0.114, 0.587, 0.299, 0.0}};
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add(matrix);
        return JAI.create((String)"bandcombine", (ParameterBlock)pb, null);
    }

    public static double[][] getExtrema(RenderedImage src) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb, null);
        return (double[][])op.getProperty("extrema");
    }

    public static double[] getExtrema(RenderedImage src, double[] extrema) {
        double[][] extr = JAIUtils.getExtrema(src);
        if (extrema == null) {
            extrema = new double[]{extr[0][0], extr[1][0]};
        }
        return extrema;
    }

    public static RenderedOp createScaleOp(RenderedImage src, double xScale, double yScale, double xTrans, double yTrans, Interpolation ip) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add((float)xScale);
        pb.add((float)yScale);
        pb.add((float)xTrans);
        pb.add((float)yTrans);
        pb.add(ip);
        return JAI.create((String)"scale", (ParameterBlock)pb, null);
    }

    public static RenderedOp createRectifyOp(RenderedImage src, int degree, RectificationGrid grid, Interpolation interp) {
        WarpPolynomial warp = WarpPolynomial.createWarp((float[])grid.sourceCoords, (int)0, (float[])grid.destCoords, (int)0, (int)grid.numCoords, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)degree);
        if (interp == null) {
            interp = new InterpolationNearest();
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add(warp);
        pb.add(interp);
        return JAI.create((String)"warp", (ParameterBlock)pb);
    }

    public static RenderedOp createRescaleOp(RenderedImage src, double scale, double offset) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add(new double[]{scale});
        pb.add(new double[]{offset});
        return JAI.create((String)"rescale", (ParameterBlock)pb, null);
    }

    public static RenderedOp createFormatOp(RenderedImage src, int dataType) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add(dataType);
        RenderingHints rh = null;
        if (dataType == 0) {
            ColorModel cm = ImageUtils.create8BitGreyscaleColorModel();
            SampleModel sm = cm.createCompatibleSampleModel(src.getTileWidth(), src.getTileHeight());
            ImageLayout layout = new ImageLayout(src);
            layout.setColorModel(cm);
            layout.setSampleModel(sm);
            rh = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        return JAI.create((String)"format", (ParameterBlock)pb, rh);
    }

    public static RenderedOp createClampOp(RenderedImage src, double minValue, double maxValue) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add(new double[]{minValue});
        pb.add(new double[]{maxValue});
        return JAI.create((String)"clamp", (ParameterBlock)pb, null);
    }

    public static RenderedOp createLookupOp(RenderedImage src, byte[][] lookupTable) {
        LookupTableJAI lookup = new LookupTableJAI(lookupTable);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add(lookup);
        return JAI.create((String)"lookup", (ParameterBlock)pb, null);
    }

    public static RenderedOp createLogOp(RenderedImage src) {
        return JAI.create((String)"log", (RenderedImage)src);
    }

    public static RenderedOp createExpOp(RenderedImage src) {
        return JAI.create((String)"exp", (RenderedImage)src);
    }

    public static RenderedOp createNullOp(RenderingHints rh) {
        ParameterBlock pb = new ParameterBlock();
        return JAI.create((String)"null", (ParameterBlock)pb, (RenderingHints)rh);
    }

    public static RenderedOp createRotateOp(RenderedImage src, double xOrigin, double yOrigin, double angle) {
        angle *= Math.PI / 180;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(src);
        pb.add((float)xOrigin);
        pb.add((float)yOrigin);
        pb.add((float)angle);
        pb.add(new InterpolationNearest());
        return JAI.create((String)"rotate", (ParameterBlock)pb, null);
    }

    public static RenderedOp createByteCastOp(RenderedImage src) {
        return JAIUtils.createFormatOp(src, 0);
    }

    public static RenderedOp createShortCastOp(RenderedImage src) {
        return JAIUtils.createFormatOp(src, 2);
    }

    public static RenderedOp createUShortCastOp(RenderedImage src) {
        return JAIUtils.createFormatOp(src, 1);
    }

    public static RenderedOp createIntCastOp(RenderedImage src) {
        return JAIUtils.createFormatOp(src, 3);
    }

    public static RenderedOp createStretchOp(RenderedImage src, double minValue, double maxValue) {
        return JAIUtils.createStretchOp(src, minValue, maxValue, 0.0, 1.0);
    }

    public static RenderedOp createStretchOp(RenderedImage src, double minValueOld, double maxValueOld, double minValueNew, double maxValueNew) {
        double scale = (maxValueNew - minValueNew) / (maxValueOld - minValueOld);
        return JAIUtils.createRescaleOp(src, scale, minValueNew - minValueOld * scale);
    }

    public static RenderedOp createValueToIndexOp(RenderedImage src, double minValue, double maxValue, int numIndices) {
        double minValueNew = 0.0;
        double maxValueNew = numIndices;
        JAIDebug.trace("createValueToIndexOp.src", src);
        RenderedOp op1 = JAIUtils.createStretchOp(src, minValue, maxValue, minValueNew, maxValueNew);
        JAIDebug.trace("createValueToIndexOp.op1", (RenderedImage)op1);
        RenderedOp op2 = JAIUtils.createClampOp((RenderedImage)op1, minValueNew, maxValueNew - 1.0);
        JAIDebug.trace("createValueToIndexOp.op2", (RenderedImage)op2);
        RenderedOp op3 = null;
        op3 = numIndices <= 256 ? JAIUtils.createByteCastOp((RenderedImage)op2) : (numIndices <= Short.MAX_VALUE ? JAIUtils.createShortCastOp((RenderedImage)op2) : (numIndices <= 65536 ? JAIUtils.createUShortCastOp((RenderedImage)op2) : JAIUtils.createIntCastOp((RenderedImage)op2)));
        JAIDebug.trace("createValueToIndexOp.op3", (RenderedImage)op2);
        return op3;
    }

    public static RenderedOp createValueToIndexOp(RenderedImage src, int numIndices) {
        double[] extrema = JAIUtils.getExtrema(src, null);
        return JAIUtils.createValueToIndexOp(src, extrema[0], extrema[1], numIndices);
    }

    public static PlanarImage createPaletteOp(RenderedImage src, byte[] r, byte[] g, byte[] b) {
        int size = Math.min(Math.min(r.length, g.length), b.length);
        int bits = size <= 256 ? 8 : 16;
        IndexColorModel colorModel = new IndexColorModel(bits, size, r, g, b);
        ImageLayout layout = new ImageLayout();
        layout.setColorModel((ColorModel)colorModel);
        return new NullOpImage(src, layout, null, 1);
    }

    public static PlanarImage createWindowLevelImage(RenderedImage image, double window, double level) {
        Guardian.assertNotNull("image", image);
        double low = level - window / 2.0;
        double high = level + window / 2.0;
        return JAIUtils.createRescaledImage(image, low, high);
    }

    public static PlanarImage createRescaledImage(RenderedImage image, double low, double high) {
        Guardian.assertNotNull("image", image);
        ParameterBlock pb = null;
        RenderedOp dst = null;
        int bands = image.getSampleModel().getNumBands();
        int dtype = image.getSampleModel().getDataType();
        if (dtype == 0) {
            double y_int;
            double slope;
            if (high != low) {
                slope = 256.0 / (high - low);
                y_int = 256.0 - slope * high;
            } else {
                slope = 0.0;
                y_int = 0.0;
            }
            byte[][] lut = new byte[bands][256];
            for (int j = 0; j < bands; ++j) {
                byte[] lutb = lut[j];
                for (int i = 0; i < 256; ++i) {
                    int value = (int)(slope * (double)i + y_int);
                    value = value < (int)low ? 0 : (value > (int)high ? 255 : (value &= 0xFF));
                    lutb[i] = (byte)value;
                }
            }
            LookupTableJAI lookup = new LookupTableJAI(lut);
            pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(lookup);
            dst = JAI.create((String)"lookup", (ParameterBlock)pb, null);
        } else if (dtype == 2 || dtype == 1) {
            double y_int;
            double slope;
            if (high != low) {
                slope = 256.0 / (high - low);
                y_int = 256.0 - slope * high;
            } else {
                slope = 0.0;
                y_int = 0.0;
            }
            byte[][] lut = new byte[bands][65536];
            for (int j = 0; j < bands; ++j) {
                byte[] lutb = lut[j];
                for (int i = 0; i < 65535; ++i) {
                    int value = (int)(slope * (double)i + y_int);
                    if (dtype == 1) {
                        value &= 0xFFFF;
                    }
                    value = value < (int)low ? 0 : (value > (int)high ? 255 : (value &= 0xFF));
                    lutb[i] = (byte)value;
                }
            }
            LookupTableJAI lookup = new LookupTableJAI(lut);
            pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(lookup);
            dst = JAI.create((String)"lookup", (ParameterBlock)pb, null);
        } else if (dtype == 3 || dtype == 4 || dtype == 5) {
            double y_int;
            double slope;
            if (high != low) {
                slope = 256.0 / (high - low);
                y_int = 256.0 - slope * high;
            } else {
                slope = 0.0;
                y_int = 0.0;
            }
            dst = JAIUtils.createRescaleOp(image, slope, y_int);
            pb = new ParameterBlock();
            pb.addSource(dst);
            pb.add(0);
            dst = JAI.create((String)"format", (ParameterBlock)pb, null);
        }
        return dst;
    }

    public static Histogram getHistogramOf(PlanarImage sourceImage) {
        Object property = sourceImage.getProperty("histogram");
        if (property instanceof Histogram) {
            return (Histogram)property;
        }
        return null;
    }

    public static double[] getNativeMinMaxOf(PlanarImage sourceImage, double[] minmax) {
        return ImageUtils.getDataTypeMinMax(sourceImage.getSampleModel().getDataType(), minmax);
    }

    public static RenderedOp createHistogramImage(PlanarImage sourceImage, int binCount) {
        double[] minmax = JAIUtils.getNativeMinMaxOf(sourceImage, null);
        return JAIUtils.createHistogramImage(sourceImage, binCount, minmax[0], minmax[1]);
    }

    public static RenderedOp createHistogramImage(PlanarImage sourceImage, int binCount, double minValue, double maxValue) {
        int numBands = sourceImage.getSampleModel().getNumBands();
        int[] numBins = new int[numBands];
        double[] lowValue = new double[numBands];
        double[] highValue = new double[numBands];
        for (int i = 0; i < numBands; ++i) {
            numBins[i] = binCount;
            lowValue[i] = minValue;
            highValue[i] = maxValue;
        }
        Histogram histogram = new Histogram(numBins, lowValue, highValue);
        sourceImage.setProperty("histogram", (Object)histogram);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImage);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        pb.add(histogram.getNumBins());
        pb.add(histogram.getLowValue());
        pb.add(histogram.getHighValue());
        return JAI.create((String)"histogram", (ParameterBlock)pb, null);
    }

    public static RenderedOp createHistogramEqualizedImage(PlanarImage sourceImage) {
        int numBands = sourceImage.getSampleModel().getNumBands();
        Histogram histogram = JAIUtils.getHistogramOf(sourceImage);
        if (histogram == null) {
            sourceImage = JAIUtils.createHistogramImage(sourceImage, 256);
            histogram = JAIUtils.getHistogramOf(sourceImage);
        }
        float[][] eqCDF = new float[numBands][];
        for (int b = 0; b < numBands; ++b) {
            int binCount = histogram.getNumBins(b);
            eqCDF[b] = new float[binCount];
            for (int i = 0; i < binCount; ++i) {
                eqCDF[b][i] = (float)(i + 1) / (float)binCount;
            }
        }
        return JAI.create((String)"matchcdf", (RenderedImage)sourceImage, (Object)eqCDF);
    }

    public static RenderedOp createHistogramNormalizedImage(PlanarImage sourceImage) {
        double[] minmax = JAIUtils.getNativeMinMaxOf(sourceImage, null);
        double dev = minmax[1] - minmax[0];
        double mean = minmax[0] + 0.5 * dev;
        double stdDev = 0.25 * dev;
        int numBands = sourceImage.getSampleModel().getNumBands();
        double[] means = new double[numBands];
        Arrays.fill(means, mean);
        double[] stdDevs = new double[numBands];
        Arrays.fill(stdDevs, stdDev);
        return JAIUtils.createHistogramNormalizedImage(sourceImage, means, stdDevs);
    }

    public static RenderedOp createHistogramNormalizedImage(PlanarImage sourceImage, double[] mean, double[] stdDev) {
        int binCount;
        int b;
        int numBands = sourceImage.getSampleModel().getNumBands();
        Assert.argument((numBands == mean.length ? 1 : 0) != 0, (String)"length of mean must be equal to number of bands in the image");
        Assert.argument((numBands == stdDev.length ? 1 : 0) != 0, (String)"length of stdDev must be equal to number of bands in the image");
        Histogram histogram = JAIUtils.getHistogramOf(sourceImage);
        if (histogram == null) {
            sourceImage = JAIUtils.createHistogramImage(sourceImage, 256);
            histogram = JAIUtils.getHistogramOf(sourceImage);
        }
        float[][] normCDF = new float[numBands][];
        for (b = 0; b < numBands; ++b) {
            binCount = histogram.getNumBins(b);
            normCDF[b] = new float[binCount];
            double mu = mean[b];
            double twoSigmaSquared = 2.0 * stdDev[b] * stdDev[b];
            normCDF[b][0] = (float)Math.exp(-mu * mu / twoSigmaSquared);
            for (int i = 1; i < binCount; ++i) {
                double deviation = (double)i - mu;
                normCDF[b][i] = normCDF[b][i - 1] + (float)Math.exp(-deviation * deviation / twoSigmaSquared);
            }
        }
        for (b = 0; b < numBands; ++b) {
            binCount = histogram.getNumBins(b);
            double CDFnormLast = normCDF[b][binCount - 1];
            int i = 0;
            while (i < binCount) {
                float[] fArray = normCDF[b];
                int n = i++;
                fArray[n] = (float)((double)fArray[n] / CDFnormLast);
            }
        }
        return JAI.create((String)"matchcdf", (RenderedImage)sourceImage, (Object)normCDF);
    }

    public static PlanarImage createAlphaOverlay(PlanarImage baseImage, PlanarImage alphaImage, Color color) {
        ParameterBlock pb;
        PlanarImage sourcePIm1;
        PlanarImage sourcePIm2 = baseImage;
        PlanarImage alphaPIm1 = alphaImage;
        byte r = (byte)color.getRed();
        byte g = (byte)color.getGreen();
        byte b = (byte)color.getBlue();
        int w = alphaPIm1.getWidth();
        int h = alphaPIm1.getHeight();
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setTileWidth(baseImage.getTileWidth());
        imageLayout.setTileHeight(baseImage.getTileHeight());
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        if (sourcePIm2.getColorModel() instanceof IndexColorModel) {
            IndexColorModel cm = new IndexColorModel(8, 1, new byte[]{r}, new byte[]{g}, new byte[]{b});
            byte[] data = new byte[w * h];
            BufferedImage sourceBIm1 = ImageUtils.createIndexedImage(w, h, data, cm);
            sourcePIm1 = PlanarImage.wrapRenderedImage((RenderedImage)sourceBIm1);
        } else {
            Byte[] bandColors = new Byte[]{r, g, b};
            pb = new ParameterBlock();
            pb.add(new Float(w));
            pb.add(new Float(h));
            pb.add(bandColors);
            sourcePIm1 = JAI.create((String)"constant", (ParameterBlock)pb, (RenderingHints)renderingHints);
        }
        pb = new ParameterBlock();
        pb.add(new Float(w));
        pb.add(new Float(h));
        pb.add(new Byte[]{(byte)-1});
        RenderedOp alphaPIm2 = JAI.create((String)"constant", (ParameterBlock)pb, (RenderingHints)renderingHints);
        pb = new ParameterBlock();
        pb.addSource(sourcePIm1);
        pb.addSource(sourcePIm2);
        pb.add(alphaPIm1);
        pb.add(alphaPIm2);
        pb.add(Boolean.FALSE);
        pb.add(CompositeDescriptor.NO_DESTINATION_ALPHA);
        RenderedOp sourcePIm3 = JAI.create((String)"composite", (ParameterBlock)pb, (RenderingHints)renderingHints);
        return sourcePIm3;
    }

    public static LookupTableJAI createColorLookupTable(IndexColorModel icm) {
        int numBands = icm.hasAlpha() ? 4 : 3;
        byte[][] data = new byte[numBands][icm.getMapSize()];
        icm.getReds(data[0]);
        icm.getGreens(data[1]);
        icm.getBlues(data[2]);
        if (numBands == 4) {
            icm.getAlphas(data[3]);
        }
        return new LookupTableJAI(data);
    }

    public static Dimension computePreferredTileSize(int imageWidth, int imageHeight, int granularity) {
        return new Dimension(JAIUtils.computePreferredTileSize(imageWidth, granularity), JAIUtils.computePreferredTileSize(imageHeight, granularity));
    }

    private static int computePreferredTileSize(int imageSize, int granularity) {
        if (imageSize <= 640) {
            return imageSize;
        }
        for (int u = 640; u >= 256; u -= 64) {
            if (imageSize % u != 0) continue;
            return u;
        }
        int minDelta = Integer.MAX_VALUE;
        int tileSize = -1;
        for (int u = 640; u >= 256; u -= granularity) {
            int delta;
            int n = imageSize / u;
            if (n * u == imageSize) {
                return u;
            }
            if (n * u < imageSize) {
                ++n;
            }
            if ((delta = Math.abs(n * u - imageSize)) >= minDelta) continue;
            minDelta = delta;
            tileSize = u;
        }
        Assert.state((tileSize != -1 ? 1 : 0) != 0);
        return tileSize;
    }

    public static PlanarImage createMapping2(RenderedImage sourceImage, IntMap indexMap) {
        Raster sourceData = sourceImage.getData();
        WritableRaster targetData = sourceData.createCompatibleWritableRaster();
        DataBuffer targetBuffer = targetData.getDataBuffer();
        for (int i = 0; i < targetBuffer.getSize(); ++i) {
            int index = indexMap.getValue(sourceData.getDataBuffer().getElem(i));
            targetBuffer.setElem(i, index);
        }
        BufferedImage image = new BufferedImage(sourceData.getWidth(), sourceData.getHeight(), 10);
        image.setData(targetData);
        return PlanarImage.wrapRenderedImage((RenderedImage)image);
    }

    public static PlanarImage createIndexedImage(RenderedImage sourceImage, IntMap intMap, int undefinedIndex) {
        LookupTableJAI lookup;
        if (sourceImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException();
        }
        int[][] ranges = intMap.getRanges();
        int keyMin = ranges[0][0];
        int keyMax = ranges[0][1];
        int valueMin = ranges[1][0];
        int valueMax = ranges[1][1];
        int keyRange = 1 + keyMax - keyMin;
        int valueRange = 1 + valueMax - valueMin;
        if (keyRange > Short.MAX_VALUE) {
            throw new IllegalArgumentException("intMap: keyRange > Short.MAX_VALUE");
        }
        if (valueRange <= 256) {
            byte[] table = new byte[keyRange + 2];
            for (int i = 1; i < table.length - 1; ++i) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = (byte)(value != Integer.MIN_VALUE ? value : undefinedIndex);
            }
            table[0] = (byte)undefinedIndex;
            table[table.length - 1] = (byte)undefinedIndex;
            lookup = new LookupTableJAI(table, keyMin - 1);
        } else if (valueRange <= 65536) {
            short[] table = new short[keyRange + 2];
            for (int i = 1; i < table.length; ++i) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = (short)(value != Integer.MIN_VALUE ? value : undefinedIndex);
            }
            table[0] = (short)undefinedIndex;
            table[table.length - 1] = (short)undefinedIndex;
            lookup = new LookupTableJAI(table, keyMin - 1, valueRange > Short.MAX_VALUE);
        } else {
            int[] table = new int[keyRange + 2];
            for (int i = 1; i < table.length; ++i) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = value != Integer.MIN_VALUE ? value : undefinedIndex;
            }
            table[0] = undefinedIndex;
            table[table.length - 1] = undefinedIndex;
            lookup = new LookupTableJAI(table, keyMin - 1);
        }
        sourceImage = ClampDescriptor.create((RenderedImage)sourceImage, (double[])new double[]{keyMin - 1}, (double[])new double[]{keyMax + 1}, null);
        return LookupDescriptor.create((RenderedImage)sourceImage, (LookupTableJAI)lookup, null);
    }
}

