/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.jai;

import java.awt.geom.AffineTransform;

public class RectificationGrid {
    int width;
    int height;
    int numCoords;
    float[] sourceCoords;
    float[] destCoords;

    public RectificationGrid(int width, int height) {
        this.width = width;
        this.height = height;
        this.numCoords = width * height;
        int length = 2 * this.numCoords;
        this.sourceCoords = new float[length];
        this.destCoords = new float[length];
    }

    public static RectificationGrid createRectangular(int imgWidth, int imgHeight, int xStep, int yStep) {
        int width = 1 + imgWidth / xStep;
        int height = 1 + imgHeight / yStep;
        RectificationGrid grid = new RectificationGrid(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = 2 * (y * width + x);
                float f = (float)(x * xStep) + 0.5f;
                grid.destCoords[index + 0] = f;
                grid.sourceCoords[index + 0] = f;
                float f2 = (float)(y * yStep) + 0.5f;
                grid.destCoords[index + 1] = f2;
                grid.sourceCoords[index + 1] = f2;
            }
        }
        return grid;
    }

    public static RectificationGrid createTestGrid(int imgWidth, int imgHeight, int xStep, int yStep) {
        RectificationGrid grid = RectificationGrid.createRectangular(imgWidth, imgHeight, xStep, yStep);
        for (int y = 0; y < grid.height; ++y) {
            for (int x = 0; x < grid.width; ++x) {
                int index = 2 * (y * grid.width + x);
                float stretch = (float)y / (float)grid.height;
                stretch *= stretch;
                int n = index;
                grid.destCoords[n] = grid.destCoords[n] / (float)imgWidth;
                int n2 = index;
                grid.destCoords[n2] = grid.destCoords[n2] - 0.5f;
                int n3 = index;
                grid.destCoords[n3] = grid.destCoords[n3] * (0.6f + 0.2f * stretch);
                int n4 = index;
                grid.destCoords[n4] = grid.destCoords[n4] + 0.5f;
                int n5 = index;
                grid.destCoords[n5] = grid.destCoords[n5] * (float)imgWidth;
            }
        }
        AffineTransform af = AffineTransform.getRotateInstance(0.3490658503988659, 0.5 * (double)imgWidth, 0.5 * (double)imgHeight);
        af.transform(grid.destCoords, 0, grid.destCoords, 0, grid.numCoords);
        return grid;
    }
}

