/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.jai;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.SampleModel;
import javax.media.jai.ComponentSampleModelJAI;
import org.esa.beam.util.ImageUtils;

public class SingleBandedSampleModel
extends ComponentSampleModelJAI {
    public SingleBandedSampleModel(int dataType, int w, int h) {
        super(dataType, w, h, 1, w, new int[]{0});
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SingleBandedSampleModel(this.dataType, w, h);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        return this.createCompatibleSampleModel(this.width, this.height);
    }

    public final int getOffset(int x, int y) {
        return y * this.width + x;
    }

    public final int getOffset(int x, int y, int b) {
        return y * this.width + x;
    }

    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        if (obj == null) {
            obj = ImageUtils.createDataBufferArray(data.getDataType(), w * h);
        }
        this.getSamplesFast(x, y, w, h, obj, ImageUtils.getPrimitiveArray(data), data.getOffset());
        return obj;
    }

    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        this.setSamplesFast(x, y, w, h, obj, ImageUtils.getPrimitiveArray(data), data.getOffset());
    }

    public int[] getPixels(int x, int y, int w, int h, int[] array, DataBuffer data) {
        return this.getSamples(x, y, w, h, 0, array, data);
    }

    public float[] getPixels(int x, int y, int w, int h, float[] array, DataBuffer data) {
        return this.getSamples(x, y, w, h, 0, array, data);
    }

    public double[] getPixels(int x, int y, int w, int h, double[] array, DataBuffer data) {
        return this.getSamples(x, y, w, h, 0, array, data);
    }

    public void setPixels(int x, int y, int w, int h, int[] array, DataBuffer data) {
        this.setSamples(x, y, w, h, 0, array, data);
    }

    public void setPixels(int x, int y, int w, int h, float[] array, DataBuffer data) {
        this.setSamples(x, y, w, h, 0, array, data);
    }

    public void setPixels(int x, int y, int w, int h, double[] array, DataBuffer data) {
        this.setSamples(x, y, w, h, 0, array, data);
    }

    public int[] getPixel(int x, int y, int[] array, DataBuffer data) {
        if (array == null) {
            array = new int[]{this.getSample(x, y, 0, data)};
        }
        return array;
    }

    public float[] getPixel(int x, int y, float[] array, DataBuffer data) {
        if (array == null) {
            array = new float[]{this.getSampleFloat(x, y, 0, data)};
        }
        return array;
    }

    public double[] getPixel(int x, int y, double[] array, DataBuffer data) {
        if (array == null) {
            array = new double[]{this.getSampleDouble(x, y, 0, data)};
        }
        return array;
    }

    public void setPixel(int x, int y, int[] array, DataBuffer data) {
        this.setSample(x, y, 0, array[0], data);
    }

    public void setPixel(int x, int y, float[] array, DataBuffer data) {
        this.setSample(x, y, 0, array[0], data);
    }

    public void setPixel(int x, int y, double[] array, DataBuffer data) {
        this.setSample(x, y, 0, array[0], data);
    }

    public int[] getSamples(int x, int y, int w, int h, int b, int[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (array == null) {
            array = new int[w * h];
        }
        if (this.dataType == 3) {
            this.getSamplesFast(x, y, w, h, array, ((DataBufferInt)data).getData(), data.getOffset());
        } else if (this.dataType == 2) {
            short[] dataArray = new short[w * h];
            this.getSamplesFast(x, y, w, h, dataArray, ((DataBufferShort)data).getData(), data.getOffset());
            int i = 0;
            for (int n : dataArray) {
                array[i++] = n;
            }
        } else {
            super.getSamples(x, y, w, h, b, array, data);
        }
        return array;
    }

    public float[] getSamples(int x, int y, int w, int h, int b, float[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (array == null) {
            array = new float[w * h];
        }
        if (this.dataType == 4) {
            this.getSamplesFast(x, y, w, h, array, ((DataBufferFloat)data).getData(), data.getOffset());
        } else if (this.dataType == 2) {
            short[] dataArray = new short[w * h];
            this.getSamplesFast(x, y, w, h, dataArray, ((DataBufferShort)data).getData(), data.getOffset());
            int i = 0;
            for (short v : dataArray) {
                array[i++] = v;
            }
        } else if (this.dataType == 3) {
            int[] dataArray = new int[w * h];
            this.getSamplesFast(x, y, w, h, dataArray, ((DataBufferInt)data).getData(), data.getOffset());
            int i = 0;
            for (int v : dataArray) {
                array[i++] = v;
            }
        } else {
            int Offset = 0;
            for (int i = y; i < h + y; ++i) {
                for (int j = x; j < w + x; ++j) {
                    array[Offset++] = this.getSampleFloat(j, i, b, data);
                }
            }
        }
        return array;
    }

    public double[] getSamples(int x, int y, int w, int h, int b, double[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (array == null) {
            array = new double[w * h];
        }
        if (this.dataType == 5) {
            this.getSamplesFast(x, y, w, h, array, ((DataBufferDouble)data).getData(), data.getOffset());
        } else if (this.dataType == 2) {
            short[] dataArray = new short[w * h];
            this.getSamplesFast(x, y, w, h, dataArray, ((DataBufferShort)data).getData(), data.getOffset());
            int i = 0;
            for (short v : dataArray) {
                array[i++] = v;
            }
        } else if (this.dataType == 3) {
            int[] dataArray = new int[w * h];
            this.getSamplesFast(x, y, w, h, dataArray, ((DataBufferInt)data).getData(), data.getOffset());
            int i = 0;
            for (int v : dataArray) {
                array[i++] = v;
            }
        } else if (this.dataType == 4) {
            float[] dataArray = new float[w * h];
            this.getSamplesFast(x, y, w, h, dataArray, ((DataBufferFloat)data).getData(), data.getOffset());
            int i = 0;
            for (float v : dataArray) {
                array[i++] = v;
            }
        } else {
            super.getSamples(x, y, w, h, b, array, data);
        }
        return array;
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (this.dataType == 3) {
            this.setSamplesFast(x, y, w, h, array, ((DataBufferInt)data).getData(), data.getOffset());
        } else {
            super.setSamples(x, y, w, h, b, array, data);
        }
    }

    public void setSamples(int x, int y, int w, int h, int b, float[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (this.dataType == 4) {
            this.setSamplesFast(x, y, w, h, array, ((DataBufferFloat)data).getData(), data.getOffset());
        } else {
            super.setSamples(x, y, w, h, b, array, data);
        }
    }

    public void setSamples(int x, int y, int w, int h, int b, double[] array, DataBuffer data) {
        this.checkBounds(x, y, w, h);
        if (this.dataType == 5) {
            this.setSamplesFast(x, y, w, h, array, ((DataBufferDouble)data).getData(), data.getOffset());
        } else {
            super.setSamples(x, y, w, h, b, array, data);
        }
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        this.checkBounds(x, y);
        return data.getElem(y * this.width + x);
    }

    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        this.checkBounds(x, y);
        return data.getElemFloat(y * this.width + x);
    }

    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        this.checkBounds(x, y);
        return data.getElemDouble(y * this.width + x);
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        this.checkBounds(x, y);
        data.setElem(y * this.width + x, s);
    }

    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        this.checkBounds(x, y);
        data.setElemFloat(y * this.width + x, s);
    }

    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        this.checkBounds(x, y);
        data.setElemDouble(y * this.width + x, s);
    }

    private void setSamplesFast(int x, int y, int w, int h, Object sourceArray, Object targetArray, int targetOffset) {
        int targetIndex = y * this.width + x;
        if (w == this.width) {
            System.arraycopy(sourceArray, 0, targetArray, targetOffset + targetIndex, w * h);
        } else {
            for (int i = 0; i < h; ++i) {
                System.arraycopy(sourceArray, i * w, targetArray, targetOffset + targetIndex, w);
                targetIndex += this.width;
            }
        }
    }

    private void getSamplesFast(int x, int y, int w, int h, Object targetArray, Object sourceArray, int sourceOffset) {
        int sourceIndex = y * this.width + x;
        if (w == this.width) {
            System.arraycopy(sourceArray, sourceOffset + sourceIndex, targetArray, 0, w * h);
        } else {
            for (int i = 0; i < h; ++i) {
                System.arraycopy(sourceArray, sourceOffset + sourceIndex, targetArray, i * w, w);
                sourceIndex += this.width;
            }
        }
    }

    private void checkBounds(int x, int y, int w, int h) {
        this.checkBounds(x, y);
        this.checkBounds(x + w - 1, y + h - 1);
    }

    private void checkBounds(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(String.format("(x < 0) || (y < 0) || (x >= %d) || (y >= %d) for x=%d,y=%d", this.width, this.height, x, y));
        }
    }
}

