/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.kmz;

import java.awt.image.RenderedImage;
import org.esa.beam.util.kmz.KmlFeature;

public abstract class KmlOverlay
extends KmlFeature {
    private final RenderedImage overlay;
    private String iconName;
    private static final String ICON_EXTENSION = ".png";

    protected KmlOverlay(String kmlElementName, String name, RenderedImage overlay) {
        super(kmlElementName, name, null);
        this.overlay = overlay;
        this.iconName = name;
    }

    public RenderedImage getOverlay() {
        return this.overlay;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String getIconFileName() {
        return this.getIconName() + ICON_EXTENSION;
    }

    @Override
    protected void createKmlSpecifics(StringBuilder sb) {
        sb.append("<Icon>");
        sb.append("<href>").append(this.getIconFileName()).append("</href>");
        sb.append("</Icon>");
    }
}

