/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import org.esa.beam.util.math.FX;
import org.esa.beam.util.math.FXY;
import org.esa.beam.util.math.FXYSum;

public class Approximator {
    public static void approximateFX(double[][] data, int[] indices, FX[] f, double[] c) {
        int n = f.length;
        int m = data.length;
        double[][] a = new double[n][n];
        double[] b = new double[n];
        int iX = 0;
        int iY = 1;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
        }
        for (int i = 0; i < n; ++i) {
            double result;
            double x;
            int k;
            int j;
            for (j = i; j < n; ++j) {
                for (k = 0; k < m; ++k) {
                    x = data[k][iX];
                    result = f[i].f(x) * f[j].f(x);
                    if (Double.isNaN(result)) continue;
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + result;
                }
            }
            for (j = 0; j < i; ++j) {
                a[i][j] = a[j][i];
            }
            for (k = 0; k < m; ++k) {
                double y = data[k][iY];
                x = data[k][iX];
                result = y * f[i].f(x);
                if (Double.isNaN(result)) continue;
                int n3 = i;
                b[n3] = b[n3] + result;
            }
        }
        Approximator.solve2(a, b, c);
    }

    public static void approximateFXY(double[][] data, int[] indices, FXY[] f, double[] c) {
        int n = f.length;
        int m = data.length;
        double[][] a = new double[n][n];
        double[] b = new double[n];
        int iX = 0;
        int iY = 1;
        int iZ = 2;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
            iZ = indices[2];
        }
        for (int i = 0; i < n; ++i) {
            double y;
            double x;
            int j;
            for (j = i; j < n; ++j) {
                double[][] dArray = data;
                int n2 = dArray.length;
                for (int k = 0; k < n2; ++k) {
                    double[] point = dArray[k];
                    x = point[iX];
                    y = point[iY];
                    double result = f[i].f(x, y) * f[j].f(x, y);
                    if (Double.isNaN(result)) continue;
                    double[] dArray2 = a[i];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + result;
                }
            }
            for (j = 0; j < i; ++j) {
                a[i][j] = a[j][i];
            }
            for (double[] point : data) {
                double z = point[iZ];
                x = point[iX];
                y = point[iY];
                double result = z * f[i].f(x, y);
                if (Double.isNaN(result)) continue;
                int n4 = i;
                b[n4] = b[n4] + result;
            }
        }
        Approximator.solve2(a, b, c);
    }

    public static double getRMSE(double[][] data, int[] indices, FX[] f, double[] c) {
        int m = data.length;
        double mse = 0.0;
        int iX = 0;
        int iY = 1;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
        }
        for (double[] point : data) {
            double x = point[iX];
            double y = point[iY];
            double d = Approximator.computeY(f, c, x) - y;
            mse += d * d;
        }
        return Math.sqrt(mse /= (double)m);
    }

    public static double computeRMSE(double[][] data, int[] indices, FXY[] f, double[] c) {
        int m = data.length;
        double mse = 0.0;
        int iX = 0;
        int iY = 1;
        int iZ = 2;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
            iZ = indices[2];
        }
        for (double[] point : data) {
            double x = point[iX];
            double y = point[iY];
            double z = point[iZ];
            double d = FXYSum.computeZ(f, c, x, y) - z;
            mse += d * d;
        }
        return Math.sqrt(mse /= (double)m);
    }

    public static double[] computeErrorStatistics(double[][] data, int[] indices, FXY[] f, double[] c) {
        int m = data.length;
        double mse = 0.0;
        double emax = 0.0;
        int iX = 0;
        int iY = 1;
        int iZ = 2;
        if (indices != null) {
            iX = indices[0];
            iY = indices[1];
            iZ = indices[2];
        }
        for (double[] point : data) {
            double x = point[iX];
            double y = point[iY];
            double z = point[iZ];
            double d = FXYSum.computeZ(f, c, x, y) - z;
            emax = Math.max(emax, Math.abs(d));
            mse += d * d;
        }
        double rmse = Math.sqrt(mse /= (double)m);
        return new double[]{rmse, emax};
    }

    public static double computeY(FX[] f, double[] c, double x) {
        int n = f.length;
        double y = 0.0;
        for (int i = 0; i < n; ++i) {
            y += c[i] * f[i].f(x);
        }
        return y;
    }

    public static double computeZ(FXY[] f, double[] c, double x, double y) {
        return FXYSum.computeZ(f, c, x, y);
    }

    public static void solve1(double[][] a, double[] b, double[] c) {
        Matrix matrixA = new Matrix(a);
        double[][] tempB = new double[b.length][1];
        for (int i = 0; i < tempB.length; ++i) {
            tempB[i][0] = b[i];
        }
        Matrix matrixB = new Matrix(tempB);
        Matrix matrixC = matrixA.solve(matrixB);
        double[][] tempC = matrixC.getArray();
        for (int i = 0; i < tempB.length; ++i) {
            c[i] = tempC[i][0];
        }
    }

    private static void solve2(double[][] a, double[] b, double[] x) {
        int i;
        int j;
        int m = b.length;
        int n = x.length;
        Matrix matrix = new Matrix(a, m, n);
        double det = matrix.det();
        if (det == 0.0 || Double.isNaN(det) || Double.isInfinite(det)) {
            throw new ArithmeticException("Expected an invertible matrix, but matrix is degenerate: det = " + det);
        }
        SingularValueDecomposition svd = matrix.svd();
        Matrix u = svd.getU();
        Matrix v = svd.getV();
        double[] s = svd.getSingularValues();
        int rank = svd.rank();
        for (j = 0; j < rank; ++j) {
            x[j] = 0.0;
            for (i = 0; i < m; ++i) {
                int n2 = j;
                x[n2] = x[n2] + u.get(i, j) * b[i];
            }
            s[j] = x[j] / s[j];
        }
        for (j = 0; j < n; ++j) {
            x[j] = 0.0;
            for (i = 0; i < rank; ++i) {
                int n3 = j;
                x[n3] = x[n3] + v.get(j, i) * s[i];
            }
        }
    }
}

