/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import com.bc.ceres.core.ProgressMonitor;
import org.esa.beam.util.math.DoubleList;

public class Quantizer {
    public static void quantizeGeneric(Object srcValues, boolean srcUnsigned, double srcMin, double srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        if (srcValues instanceof byte[]) {
            if (srcUnsigned) {
                Quantizer.quantizeUByte((byte[])srcValues, (int)srcMin, (int)srcMax, dstValues, dstPos, dstStride, pm);
            } else {
                Quantizer.quantizeByte((byte[])srcValues, (int)srcMin, (int)srcMax, dstValues, dstPos, dstStride, pm);
            }
        } else if (srcValues instanceof short[]) {
            if (srcUnsigned) {
                Quantizer.quantizeUShort((short[])srcValues, (int)srcMin, (int)srcMax, dstValues, dstPos, dstStride, pm);
            } else {
                Quantizer.quantizeShort((short[])srcValues, (int)srcMin, (int)srcMax, dstValues, dstPos, dstStride, pm);
            }
        } else if (srcValues instanceof int[]) {
            if (srcUnsigned) {
                Quantizer.quantizeUInt((int[])srcValues, (int)srcMin, (int)srcMax, dstValues, dstPos, dstStride, pm);
            } else {
                Quantizer.quantizeInt((int[])srcValues, (int)srcMin, (int)srcMax, dstValues, dstPos, dstStride, pm);
            }
        } else if (srcValues instanceof float[]) {
            Quantizer.quantizeFloat((float[])srcValues, (float)srcMin, (float)srcMax, dstValues, dstPos, dstStride, pm);
        } else if (srcValues instanceof double[]) {
            Quantizer.quantizeDouble((double[])srcValues, srcMin, srcMax, dstValues, dstPos, dstStride, pm);
        } else if (srcValues instanceof DoubleList) {
            Quantizer.quantizeDouble((DoubleList)srcValues, srcMin, srcMax, dstValues, dstPos, dstStride, pm);
        } else {
            if (srcValues == null) {
                throw new IllegalArgumentException("srcValues is null");
            }
            throw new IllegalArgumentException("srcValues has an illegal type: " + srcValues.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeByte(byte[] srcValues, int srcMin, int srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        int delta = srcMax - srcMin;
        float srcScale = 256.0f / (float)delta;
        float srcOffset = -srcScale * (float)srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * (float)srcValues[iSrc] + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeUByte(byte[] srcValues, int srcMin, int srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        int delta = srcMax - srcMin;
        float srcScale = 256.0f / (float)delta;
        float srcOffset = -srcScale * (float)srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * (float)(srcValues[iSrc] & 0xFF) + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeShort(short[] srcValues, int srcMin, int srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        int delta = srcMax - srcMin;
        float srcScale = 256.0f / (float)delta;
        float srcOffset = -srcScale * (float)srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * (float)srcValues[iSrc] + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeUShort(short[] srcValues, int srcMin, int srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        int delta = srcMax - srcMin;
        float srcScale = 256.0f / (float)delta;
        float srcOffset = -srcScale * (float)srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * (float)(srcValues[iSrc] & 0xFFFF) + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeInt(int[] srcValues, int srcMin, int srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        int delta = srcMax - srcMin;
        float srcScale = 256.0f / (float)delta;
        float srcOffset = -srcScale * (float)srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * (float)srcValues[iSrc] + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeUInt(int[] srcValues, long srcMin, long srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        long delta = srcMax - srcMin;
        float srcScale = 256.0f / (float)delta;
        float srcOffset = -srcScale * (float)srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0L) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * (float)((long)srcValues[iSrc] & 0xFFFFFFFFL) + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeFloat(float[] srcValues, float srcMin, float srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        float delta = srcMax - srcMin;
        float srcScale = 256.0f / delta;
        float srcOffset = -srcScale * srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0.0f) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * srcValues[iSrc] + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeDouble(double[] srcValues, double srcMin, double srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.length;
        double delta = srcMax - srcMin;
        double srcScale = 256.0 / delta;
        double srcOffset = -srcScale * srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0.0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * srcValues[iSrc] + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quantizeDouble(DoubleList srcValues, double srcMin, double srcMax, byte[] dstValues, int dstPos, int dstStride, ProgressMonitor pm) {
        int srcSize = srcValues.getSize();
        double delta = srcMax - srcMin;
        double srcScale = 256.0 / delta;
        double srcOffset = -srcScale * srcMin;
        pm.beginTask("Quantize values...", srcSize);
        try {
            if (delta == 0.0) {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    dstValues[iDst] = 0;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            } else {
                int iSrc = 0;
                int iDst = dstPos;
                while (iSrc < srcSize) {
                    int quantizedValue = (int)(srcScale * srcValues.getDouble(iSrc) + srcOffset);
                    if (quantizedValue < 0) {
                        quantizedValue = 0;
                    } else if (quantizedValue > 255) {
                        quantizedValue = 255;
                    }
                    dstValues[iDst] = (byte)quantizedValue;
                    pm.worked(1);
                    ++iSrc;
                    iDst += dstStride;
                }
            }
        }
        finally {
            pm.done();
        }
    }
}

