/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.util.Guardian;

public class RsMathUtils {
    public static final double SPEC_WEIGHT_AIR = 1.26895;
    public static final double GRAVITY_ACC = 9.80665;
    public static final double BAROMETRIC_CONST = 0.12444148517499999;
    public static final float KOSCHMIEDER_CONST = 7.84f;
    public static final double RAD_PER_DEG = Math.PI / 180;
    public static final double DEG_PER_RAD = 57.29577951308232;
    public static final double MEAN_EARTH_RADIUS = 6370997.0;

    public static float radianceToReflectance(float rad, float sza, float e0) {
        return (float)((double)rad * Math.PI / ((double)e0 * Math.cos((double)sza * (Math.PI / 180))));
    }

    public static float[] radianceToReflectance(float[] rad, float[] sza, float e0, float[] recycle) {
        Guardian.assertNotNull("rad", rad);
        Guardian.assertNotNull("sza", sza);
        float[] fRet = RsMathUtils.createOrRecycleArray(recycle, Math.min(rad.length, sza.length));
        for (int i = 0; i < rad.length; ++i) {
            fRet[i] = RsMathUtils.radianceToReflectance(rad[i], sza[i], e0);
        }
        return fRet;
    }

    public static float zenithToElevation(float zenith) {
        return 90.0f - zenith;
    }

    public static float[] zenithToElevation(float[] zenith, float[] recycle) {
        Guardian.assertNotNull("zenith", zenith);
        float[] fRet = RsMathUtils.createOrRecycleArray(recycle, zenith.length);
        for (int n = 0; n < zenith.length; ++n) {
            fRet[n] = 90.0f - zenith[n];
        }
        return fRet;
    }

    public static float elevationToZenith(float elevation) {
        return 90.0f - elevation;
    }

    public static float[] elevationToZenith(float[] elevation, float[] recycle) {
        Guardian.assertNotNull("elevation", elevation);
        float[] fRet = RsMathUtils.createOrRecycleArray(recycle, elevation.length);
        for (int n = 0; n < elevation.length; ++n) {
            fRet[n] = 90.0f - elevation[n];
        }
        return fRet;
    }

    public static float simpleBarometric(float seaPress, float height) {
        return seaPress * (float)Math.exp(-0.12444148517499999 * (double)height / (double)seaPress);
    }

    public static float[] simpleBarometric(float[] seaPress, float[] height, float[] recycle) {
        Guardian.assertNotNull("seaPress", seaPress);
        Guardian.assertNotNull("height", height);
        float[] fRet = RsMathUtils.createOrRecycleArray(recycle, Math.min(seaPress.length, height.length));
        for (int n = 0; n < seaPress.length; ++n) {
            fRet[n] = seaPress[n] * (float)Math.exp(-0.12444148517499999 * (double)height[n] / (double)seaPress[n]);
        }
        return fRet;
    }

    public static float koschmieder(float visibility) {
        return RsMathUtils.computeKoschmieder(visibility);
    }

    public static float koschmiederInv(float opticalDepth) {
        return RsMathUtils.computeKoschmieder(opticalDepth);
    }

    private static float computeKoschmieder(float value) {
        if (value == 0.0f) {
            throw new IllegalArgumentException("value is zero");
        }
        return 7.84f / value;
    }

    private static float[] createOrRecycleArray(float[] recycle, int requiredSize) {
        if (recycle != null && recycle.length == requiredSize) {
            return recycle;
        }
        return new float[requiredSize];
    }

    public static void applyGeodeticCorrection(GeoPos gp, double h, double vz, double va) {
        double dx = h * Math.tan(Math.PI / 180 * vz);
        double dlat = 57.29577951308232 * dx * Math.cos(Math.PI / 180 * va) / 6370997.0;
        double dlon = 57.29577951308232 * dx * Math.sin(Math.PI / 180 * va) / (6370997.0 * Math.cos(Math.PI / 180 * (double)gp.lat));
        gp.lat = (float)((double)gp.lat + dlat);
        gp.lon = (float)((double)gp.lon + dlon);
    }
}

