/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.esa.beam.util.Debug;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

public class EnviCrsFactory {
    private static final HashMap<Integer, int[]> axisMap = new HashMap();
    private static final HashMap<Integer, String> projectionMethodMap = new HashMap();
    private static final HashMap<Integer, Map<String, Integer>> projectionParameterMaps = new HashMap();

    private EnviCrsFactory() {
    }

    public static CoordinateReferenceSystem createCrs(int enviProjectionNumber, double[] parameter, String datumString, String unitString) {
        if (projectionMethodMap.containsKey(enviProjectionNumber)) {
            String method = projectionMethodMap.get(enviProjectionNumber);
            try {
                DefaultGeographicCRS base;
                MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
                ParameterValueGroup parameters = transformFactory.getDefaultParameters(method);
                Map<String, Integer> map = projectionParameterMaps.get(enviProjectionNumber);
                List parameterDescriptors = parameters.getDescriptor().descriptors();
                for (GeneralParameterDescriptor parameterDescriptor : parameterDescriptors) {
                    String paramName = parameterDescriptor.getName().getCode();
                    if (!map.containsKey(paramName)) continue;
                    Integer index = map.get(paramName);
                    parameters.parameter(paramName).setValue(parameter[index]);
                }
                MathTransform mathTransform = transformFactory.createParameterizedTransform(parameters);
                if ("WGS-84".equals(datumString)) {
                    base = DefaultGeographicCRS.WGS84;
                } else {
                    int[] indices = axisMap.get(enviProjectionNumber);
                    if (indices != null) {
                        double semiMajorAxis = parameter[indices[0]];
                        double semiMinorAxis = parameter[indices[1]];
                        DefaultEllipsoid ellipsoid = DefaultEllipsoid.createEllipsoid((String)"SPHERE", (double)semiMajorAxis, (double)semiMinorAxis, (Unit)SI.METER);
                        DefaultGeodeticDatum datum = new DefaultGeodeticDatum(datumString, (Ellipsoid)ellipsoid, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
                        base = new DefaultGeographicCRS((GeodeticDatum)datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
                    } else {
                        base = DefaultGeographicCRS.WGS84;
                    }
                }
                return new DefaultProjectedCRS(parameters.getDescriptor().getName().getCode() + " / " + datumString, (GeographicCRS)base, mathTransform, (CartesianCS)DefaultCartesianCS.PROJECTED);
            }
            catch (FactoryException fe) {
                Debug.trace((Throwable)fe);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown ENVI projection number: %d", enviProjectionNumber));
    }

    static {
        projectionMethodMap.put(9, "EPSG:9822");
        HashMap<String, Integer> params9 = new HashMap<String, Integer>();
        params9.put("semi_major", 0);
        params9.put("semi_minor", 1);
        params9.put("latitude_of_origin", 2);
        params9.put("central_meridian", 3);
        params9.put("standard_parallel_1", 6);
        params9.put("standard_parallel_2", 7);
        params9.put("false_easting", 4);
        params9.put("false_northing", 5);
        projectionParameterMaps.put(9, params9);
        axisMap.put(9, new int[]{0, 1});
        projectionMethodMap.put(16, "OGC:Sinusoidal");
        HashMap<String, Integer> params16 = new HashMap<String, Integer>();
        params16.put("semi_major", 0);
        params16.put("semi_minor", 0);
        params16.put("central_meridian", 1);
        params16.put("false_easting", 2);
        params16.put("false_northing", 3);
        projectionParameterMaps.put(16, params16);
        axisMap.put(16, new int[]{0, 0});
    }
}

