/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.beam.dataio.envi.EnviConstants;
import org.esa.beam.dataio.envi.EnviProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.FileUtils;

public class EnviProductReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        if (input instanceof ImageInputStream) {
            return EnviProductReaderPlugIn.checkDecodeQualificationOnStream((ImageInputStream)input);
        }
        if (input != null) {
            return EnviProductReaderPlugIn.checkDecodeQualificationOnFile(new File(input.toString()));
        }
        return DecodeQualification.UNABLE;
    }

    public String[] getFormatNames() {
        return new String[]{"ENVI"};
    }

    public ProductReader createReaderInstance() {
        return new EnviProductReader(this);
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".hdr", ".zip"};
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale locale) {
        return "ENVI Data Products";
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    static File getInputFile(Object input) {
        return new File(input.toString());
    }

    static boolean isCompressedFile(File file) {
        return file.getPath().lastIndexOf(".zip") > -1;
    }

    static InputStream getHeaderStreamFromZip(ZipFile productZip) throws IOException {
        Enumeration<? extends ZipEntry> entries = productZip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (name.indexOf(".hdr") <= 0) continue;
            return productZip.getInputStream(zipEntry);
        }
        return null;
    }

    private static DecodeQualification checkDecodeQualificationOnStream(InputStream headerStream) {
        return EnviProductReaderPlugIn.checkDecodeQualificationOnStream(new MemoryCacheImageInputStream(headerStream));
    }

    private static DecodeQualification checkDecodeQualificationOnStream(ImageInputStream headerStream) {
        try {
            String line = headerStream.readLine();
            if (line != null && line.startsWith("ENVI")) {
                return DecodeQualification.SUITABLE;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DecodeQualification.UNABLE;
    }

    private static DecodeQualification checkDecodeQualificationOnFile(File inputFile) {
        try {
            String fileName = inputFile.getName().toLowerCase();
            boolean validExt = false;
            for (String ext : EnviConstants.VALID_EXTENSIONS) {
                if (!fileName.endsWith(ext)) continue;
                validExt = true;
                break;
            }
            if (!validExt) {
                return DecodeQualification.UNABLE;
            }
            if (EnviProductReaderPlugIn.isCompressedFile(inputFile)) {
                ZipFile productZip = new ZipFile(inputFile, 1);
                if (productZip.size() != 2) {
                    productZip.close();
                    return DecodeQualification.UNABLE;
                }
                InputStream headerStream = EnviProductReaderPlugIn.getHeaderStreamFromZip(productZip);
                if (headerStream != null) {
                    DecodeQualification result = EnviProductReaderPlugIn.checkDecodeQualificationOnStream(headerStream);
                    productZip.close();
                    return result;
                }
                productZip.close();
            } else if (".hdr".equalsIgnoreCase(FileUtils.getExtension((File)inputFile))) {
                FileImageInputStream headerStream = new FileImageInputStream(inputFile);
                DecodeQualification result = EnviProductReaderPlugIn.checkDecodeQualificationOnStream(headerStream);
                headerStream.close();
                return result;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DecodeQualification.UNABLE;
    }
}

