/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.esa.beam.dataio.envi.EnviMapInfo;
import org.esa.beam.dataio.envi.EnviProjectionInfo;
import org.esa.beam.dataio.envi.HeaderParser;
import org.esa.beam.framework.datamodel.MetadataElement;

public class Header {
    static final String UNKNOWN_SENSOR_TYPE = "Unknown Sensor Type";
    static final String SENSING_START = "sensingStart";
    static final String SENSING_STOP = "sensingStop";
    static final String BEAM_PROPERTIES = "beamProperties";
    private final HeaderParser headerParser;

    public Header(BufferedReader reader) throws IOException {
        this.headerParser = HeaderParser.parse(reader);
    }

    public ByteOrder getJavaByteOrder() {
        if (this.getByteOrder() == 1) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public String getFileType() {
        return this.headerParser.getString("file type", null);
    }

    public int getNumSamples() {
        return this.headerParser.getInt("samples");
    }

    public int getNumLines() {
        return this.headerParser.getInt("lines");
    }

    public int getNumBands() {
        return this.headerParser.getInt("bands", 0);
    }

    public int getHeaderOffset() {
        return this.headerParser.getInt("header offset", 0);
    }

    public int getDataType() {
        return this.headerParser.getInt("data type");
    }

    public String getInterleave() {
        return this.headerParser.getString("interleave");
    }

    public String getSensorType() {
        return this.headerParser.getString("sensor type", UNKNOWN_SENSOR_TYPE);
    }

    public int getByteOrder() {
        return this.headerParser.getInt("byte order", 0);
    }

    public EnviMapInfo getMapInfo() {
        String mapInfoString = this.headerParser.getString("map info", null);
        if (mapInfoString != null) {
            return Header.parseMapInfo(mapInfoString);
        }
        return null;
    }

    public EnviProjectionInfo getProjectionInfo() {
        String projectionInfoString = this.headerParser.getString("projection info", null);
        if (projectionInfoString != null) {
            return Header.parseProjectionInfo(projectionInfoString);
        }
        return null;
    }

    public String[] getBandNames() {
        return this.headerParser.getStrings("band names");
    }

    public String getDescription() {
        return this.headerParser.getString("description", null);
    }

    public BeamProperties getBeamProperties() {
        return Header.parseBeamProperties(this.getDescription());
    }

    public String[] getWavelengths() {
        return this.headerParser.getStrings("wavelength");
    }

    public String[] getFWHM() {
        return this.headerParser.getStrings("fwhm");
    }

    public String getWavelengthsUnit() {
        return this.headerParser.getString("wavelength units", null);
    }

    public double[] getDataOffsetValues() {
        return this.headerParser.getDoubles("data offset values");
    }

    public double[] getDataGainValues() {
        return this.headerParser.getDoubles("data gain values");
    }

    public Double getDataIgnoreValue() {
        if (this.headerParser.contains("data ignore value")) {
            return this.headerParser.getDouble("data ignore value");
        }
        return null;
    }

    public int getNumClasses() {
        return this.headerParser.getInt("classes", 0);
    }

    public String[] getClassNmaes() {
        return this.headerParser.getStrings("class names");
    }

    public int[] getClassColorRGB() {
        return this.headerParser.getInts("class lookup");
    }

    private static EnviMapInfo parseMapInfo(String line) {
        try {
            EnviMapInfo mapInfo = new EnviMapInfo();
            StringTokenizer tokenizer = Header.createTokenizerFromLine(line);
            mapInfo.setProjectionName(tokenizer.nextToken().trim());
            mapInfo.setReferencePixelX(Double.parseDouble(tokenizer.nextToken()));
            mapInfo.setReferencePixelY(Double.parseDouble(tokenizer.nextToken()));
            mapInfo.setEasting(Double.parseDouble(tokenizer.nextToken()));
            mapInfo.setNorthing(Double.parseDouble(tokenizer.nextToken()));
            mapInfo.setPixelSizeX(Double.parseDouble(tokenizer.nextToken()));
            mapInfo.setPixelSizeY(Double.parseDouble(tokenizer.nextToken()));
            if (mapInfo.getProjectionName().equalsIgnoreCase("UTM")) {
                mapInfo.setUtmZone(Integer.parseInt(tokenizer.nextToken().trim()));
                mapInfo.setUtmHemisphere(tokenizer.nextToken().trim());
            }
            mapInfo.setDatum(tokenizer.nextToken().trim());
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.startsWith("units=")) {
                    mapInfo.setUnit(token.substring("units=".length()));
                    continue;
                }
                if (!token.startsWith("rotation=")) continue;
                String rotation = token.substring("rotation=".length());
                mapInfo.setOrientation(Double.parseDouble(rotation));
            }
            return mapInfo;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static StringTokenizer createTokenizerFromLine(String line) {
        return new StringTokenizer(line, ",");
    }

    private static EnviProjectionInfo parseProjectionInfo(String line) {
        EnviProjectionInfo projectionInfo = new EnviProjectionInfo();
        StringTokenizer tokenizer = Header.createTokenizerFromLine(line);
        projectionInfo.setProjectionNumber(Integer.parseInt(tokenizer.nextToken().trim()));
        ArrayList<Double> parameterList = new ArrayList<Double>(20);
        String token = null;
        try {
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                parameterList.add(Double.parseDouble(token));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        double[] parameters = new double[parameterList.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = (Double)parameterList.get(i);
        }
        projectionInfo.setParameter(parameters);
        projectionInfo.setDatum(token);
        projectionInfo.setName(tokenizer.nextToken().trim());
        return projectionInfo;
    }

    private static BeamProperties parseBeamProperties(String txt) {
        if (txt != null && txt.contains(BEAM_PROPERTIES)) {
            int propsIdx = txt.indexOf(BEAM_PROPERTIES);
            int openIdx = txt.indexOf(91, propsIdx);
            int closeIdx = txt.indexOf(93, openIdx);
            String beamProps = txt.substring(openIdx + 1, closeIdx);
            String strings = beamProps.replace(',', '\n');
            Properties properties = Header.loadProperties(strings);
            BeamProperties bean = new BeamProperties();
            if (properties.containsKey(SENSING_START)) {
                bean.setSensingStart(properties.getProperty(SENSING_START));
            }
            if (properties.containsKey(SENSING_STOP)) {
                bean.setSensingStop(properties.getProperty(SENSING_STOP));
            }
            return bean;
        }
        return null;
    }

    public static Properties loadProperties(String text) {
        Properties properties = new Properties();
        try (ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());){
            properties.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public MetadataElement getAsMetadata() {
        MetadataElement headerElem = new MetadataElement("Header");
        for (Map.Entry<String, String> entry : this.headerParser.getHeaderEntries()) {
            String value = entry.getValue().isEmpty() ? " " : entry.getValue();
            headerElem.setAttributeString(entry.getKey(), value);
        }
        Set<Map.Entry<String, String>> historyEntries = this.headerParser.getHistoryEntries();
        if (!historyEntries.isEmpty()) {
            MetadataElement historyElem = new MetadataElement("History");
            for (Map.Entry<String, String> entry : historyEntries) {
                String value = entry.getValue().isEmpty() ? " " : entry.getValue();
                historyElem.setAttributeString(entry.getKey(), value);
            }
            headerElem.addElement(historyElem);
        }
        return headerElem;
    }

    public static class BeamProperties {
        private String sensingStart;
        private String sensingStop;

        public String getSensingStart() {
            return this.sensingStart;
        }

        public String getSensingStop() {
            return this.sensingStop;
        }

        public void setSensingStart(String sensingStart) {
            this.sensingStart = sensingStart;
        }

        public void setSensingStop(String sensingStop) {
            this.sensingStop = sensingStop;
        }
    }
}

