/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envi;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class HeaderParser {
    private final Map<String, String> header;
    private final Map<String, String> history;

    public HeaderParser(Map<String, String> header, Map<String, String> history) {
        this.header = header;
        this.history = history;
    }

    public static HeaderParser parse(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> history = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> currentMap = header;
        String line = bufferedReader.readLine();
        while (line != null) {
            if ((line = line.trim()).equals("history = begins")) {
                currentMap = history;
            } else if (line.equals("history = ends")) {
                currentMap = header;
            } else if (line.contains("=")) {
                String[] keyValue = line.split("=", 2);
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (value.startsWith("{")) {
                    value = value.substring(1).trim();
                    while (!value.endsWith("}")) {
                        String continuedLine = bufferedReader.readLine();
                        value = value + " " + continuedLine.trim();
                        value = value.trim();
                    }
                    value = value.substring(0, value.length() - 1);
                }
                currentMap.put(key, value);
            }
            line = bufferedReader.readLine();
        }
        return new HeaderParser(header, history);
    }

    boolean contains(String key) {
        return this.header.containsKey(key);
    }

    String getString(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        return this.header.get(key);
    }

    String getString(String key, String defaultValue) {
        return this.contains(key) ? this.getString(key) : defaultValue;
    }

    String[] getStrings(String key) {
        String v = this.header.get(key);
        if (v == null) {
            return new String[0];
        }
        String[] splits = v.split(",");
        ArrayList<String> splitsTrimmed = new ArrayList<String>(splits.length);
        for (String split : splits) {
            String trimmed = split.trim();
            if (trimmed.isEmpty()) continue;
            splitsTrimmed.add(trimmed);
        }
        return splitsTrimmed.toArray(new String[splitsTrimmed.size()]);
    }

    int getInt(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        return Integer.parseInt(this.getString(key));
    }

    int getInt(String key, int defaultValue) {
        return this.contains(key) ? this.getInt(key) : defaultValue;
    }

    int[] getInts(String key) {
        String[] elems = this.getStrings(key);
        int[] ints = new int[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            ints[i] = Integer.parseInt(elems[i]);
        }
        return ints;
    }

    double getDouble(String key) {
        if (!this.contains(key)) {
            throw new IllegalArgumentException("Missing mandatory header key: " + key);
        }
        return Double.parseDouble(this.getString(key));
    }

    double[] getDoubles(String key) {
        String[] elems = this.getStrings(key);
        double[] doubles = new double[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            doubles[i] = Double.parseDouble(elems[i]);
        }
        return doubles;
    }

    Set<Map.Entry<String, String>> getHeaderEntries() {
        return this.header.entrySet();
    }

    Set<Map.Entry<String, String>> getHistoryEntries() {
        return this.history.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Header\n");
        HeaderParser.mapToString(sb, this.header);
        sb.append("History\n");
        HeaderParser.mapToString(sb, this.history);
        return sb.toString();
    }

    private static void mapToString(StringBuilder sb, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
    }

    public static void main(String[] args) throws IOException {
        HeaderParser enviHeader = HeaderParser.parse(new FileReader(args[0]));
        System.out.println(enviHeader);
    }
}

