/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.hico;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import org.esa.beam.dataio.envi.EnviProductReaderPlugIn;
import org.esa.beam.dataio.hico.HicoFilename;
import org.esa.beam.dataio.hico.HicoProductReaderPlugin;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.util.ProductUtils;

class HicoProductReader
extends AbstractProductReader {
    private final EnumMap<FileType, Product> hicoProductParts = new EnumMap(FileType.class);

    HicoProductReader(HicoProductReaderPlugin hicoProductReaderPlugin) {
        super((ProductReaderPlugIn)hicoProductReaderPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        File[] hdrFiles = HicoProductReaderPlugin.findHdrFiles(this.getInput());
        if (hdrFiles.length > 0) {
            return this.createProduct(hdrFiles);
        }
        throw new ProductIOException("Failed reading HICO product");
    }

    public void close() throws IOException {
        super.close();
        for (Product product : this.hicoProductParts.values()) {
            product.dispose();
        }
    }

    private Product createProduct(File[] hdrFiles) throws IOException {
        EnviProductReaderPlugIn enviProductReaderPlugIn = new EnviProductReaderPlugIn();
        int sceneWidth = 0;
        int sceneHeight = 0;
        HicoFilename genericHicoFilename = null;
        for (File hdrFile : hdrFiles) {
            ProductReader enviProductReader = enviProductReaderPlugIn.createReaderInstance();
            Product product = enviProductReader.readProductNodes((Object)hdrFile, null);
            if (sceneHeight == 0) {
                sceneHeight = product.getSceneRasterHeight();
                sceneWidth = product.getSceneRasterWidth();
            }
            HicoFilename hicoFilename = HicoFilename.create(hdrFile.getName());
            if (genericHicoFilename == null) {
                genericHicoFilename = hicoFilename;
            }
            FileType fileType = FileType.fromString(hicoFilename.getFileType());
            this.hicoProductParts.put(fileType, product);
        }
        Product product = new Product(genericHicoFilename.getProductBase(), genericHicoFilename.getProcessingLevel(), sceneWidth, sceneHeight);
        product.setDescription("HICO data product");
        this.handleRadianceProduct(product);
        this.handleFlagProduct(product);
        this.handleNdviProduct(product);
        this.handleGeomProduct(product);
        this.handleRgbProduct(product);
        return product;
    }

    private void handleRadianceProduct(Product product) {
        Product hicoProductPart = this.hicoProductParts.get((Object)FileType.RAD);
        if (hicoProductPart != null) {
            String[] bandNames;
            this.copyMetadata(hicoProductPart, product, FileType.RAD.toString());
            for (String bandName : bandNames = hicoProductPart.getBandNames()) {
                String[] bandNameSplit = bandName.split("_");
                String newBandname = "radiance_" + bandNameSplit[1];
                Band band = ProductUtils.copyBand((String)bandName, (Product)hicoProductPart, (String)newBandname, (Product)product, (boolean)true);
                band.setScalingFactor(0.02);
                band.setSpectralBandwidth(5.7f);
            }
            product.setAutoGrouping("radiance");
            product.setFileLocation(hicoProductPart.getFileLocation());
        }
    }

    private void handleGeomProduct(Product product) throws IOException {
        Product hicoProductPart = this.hicoProductParts.get((Object)FileType.GEOM_PRECISE);
        if (hicoProductPart == null) {
            hicoProductPart = this.hicoProductParts.get((Object)FileType.GEOM);
        }
        if (hicoProductPart != null) {
            this.copyMetadata(hicoProductPart, product, FileType.GEOM.toString());
            String[] bandNames = hicoProductPart.getBandNames();
            Band latitudeBand = null;
            Band longitudeBand = null;
            for (String bandName : bandNames) {
                if (bandName.startsWith("latitude")) {
                    latitudeBand = hicoProductPart.getBand(bandName);
                    continue;
                }
                if (bandName.startsWith("longitude")) {
                    longitudeBand = hicoProductPart.getBand(bandName);
                    continue;
                }
                int i = bandName.indexOf("(");
                String newBandname = bandName.substring(0, i).trim().replace(" ", "_");
                ProductUtils.copyBand((String)bandName, (Product)hicoProductPart, (String)newBandname, (Product)product, (boolean)true);
            }
            if (latitudeBand != null && longitudeBand != null) {
                int rasterWidth = latitudeBand.getSceneRasterWidth();
                int rasterHeight = latitudeBand.getSceneRasterHeight();
                float[] latData = latitudeBand.readPixels(0, 0, rasterWidth, rasterHeight, (float[])null);
                TiePointGrid tpLat = new TiePointGrid("latitude", rasterWidth, rasterHeight, 0.5f, 0.5f, 1.0f, 1.0f, latData);
                product.addTiePointGrid(tpLat);
                float[] lonData = longitudeBand.readPixels(0, 0, rasterWidth, rasterHeight, (float[])null);
                TiePointGrid tpLon = new TiePointGrid("longitude", rasterWidth, rasterHeight, 0.5f, 0.5f, 1.0f, 1.0f, lonData);
                product.addTiePointGrid(tpLon);
                product.setGeoCoding((GeoCoding)new TiePointGeoCoding(tpLat, tpLon));
            }
        }
    }

    private void handleNdviProduct(Product product) {
        Product hicoProductPart = this.hicoProductParts.get((Object)FileType.NDVI);
        if (hicoProductPart != null) {
            String[] bandNames;
            this.copyMetadata(hicoProductPart, product, FileType.NDVI.toString());
            for (String bandName : bandNames = hicoProductPart.getBandNames()) {
                String newBandname = bandName.replace(" ", "_");
                ProductUtils.copyBand((String)bandName, (Product)hicoProductPart, (String)newBandname, (Product)product, (boolean)true);
            }
        }
    }

    private void handleRgbProduct(Product product) {
        Product hicoProductPart = this.hicoProductParts.get((Object)FileType.RGB);
        if (hicoProductPart != null && hicoProductPart.getNumBands() == 3) {
            this.copyMetadata(hicoProductPart, product, FileType.RGB.toString());
            Band red = hicoProductPart.getBandAt(0);
            Band band = ProductUtils.copyBand((String)red.getName(), (Product)hicoProductPart, (String)"red", (Product)product, (boolean)true);
            band.setSpectralWavelength(0.0f);
            Band green = hicoProductPart.getBandAt(1);
            band = ProductUtils.copyBand((String)green.getName(), (Product)hicoProductPart, (String)"green", (Product)product, (boolean)true);
            band.setSpectralWavelength(0.0f);
            Band blue = hicoProductPart.getBandAt(2);
            band = ProductUtils.copyBand((String)blue.getName(), (Product)hicoProductPart, (String)"blue", (Product)product, (boolean)true);
            band.setSpectralWavelength(0.0f);
        }
    }

    private void handleFlagProduct(Product product) {
        Product hicoProductPart = this.hicoProductParts.get((Object)FileType.FLAG);
        if (hicoProductPart != null) {
            this.copyMetadata(hicoProductPart, product, FileType.FLAG.toString());
            Band flags = hicoProductPart.getBandAt(0);
            Band flagBand = ProductUtils.copyBand((String)flags.getName(), (Product)hicoProductPart, (String)"flags", (Product)product, (boolean)true);
            FlagCoding flagCoding = new FlagCoding("flag_coding");
            flagCoding.addFlag("LAND", 1, "land (or possibly glint or clouds)(\u03c1NIR > 0.02)");
            flagCoding.addFlag("NAVWARN", 2, "latitude or longitude out of bounds");
            flagCoding.addFlag("NAVFAIL", 4, "navigation is rough (currently always set to 1)");
            flagCoding.addFlag("HISATZEN", 8, "satellite view angle > 60\u00b0");
            flagCoding.addFlag("HISOLZEN", 16, "solar zenith angle at estimated position > 75\u00b0");
            flagCoding.addFlag("SATURATE", 32, "pixel has \u2265 1 saturated bands");
            flagCoding.addFlag("CALFAIL", 64, "pixel has \u2265 bands from a dropped packet");
            flagCoding.addFlag("CLOUD", 128, "rough cloud mask (\u03c1NIR > 0.05 and \u03c1RED > 0.5) or (0.8 < \u03c1NIR/\u03c1RED < 1.1)");
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            flagBand.setSampleCoding((SampleCoding)flagCoding);
            product.addMask("LAND", "flags.LAND", "land (or possibly glint or clouds)(\u03c1NIR > 0.02)", Color.GREEN, 0.5);
            product.addMask("NAVWARN", "flags.NAVWARN", "latitude or longitude out of bounds", Color.CYAN, 0.5);
            product.addMask("NAVFAIL", "flags.NAVFAIL", "navigation is rough (currently always set to 1)", Color.CYAN.darker(), 0.5);
            product.addMask("HISATZEN", "flags.HISATZEN", "satellite view angle > 60\u00b0", Color.MAGENTA, 0.5);
            product.addMask("HISOLZEN", "flags.HISOLZEN", "solar zenith angle at estimated position > 75\u00b0", Color.PINK, 0.5);
            product.addMask("SATURATE", "flags.SATURATE", "pixel has \u2265 1 saturated bands", Color.RED, 0.5);
            product.addMask("CALFAIL", "flags.CALFAIL", "pixel has \u2265 bands from a dropped packet", Color.BLUE, 0.5);
            product.addMask("CLOUD", "flags.CLOUD", "rough cloud mask (\u03c1NIR > 0.05 and \u03c1RED > 0.5) or (0.8 < \u03c1NIR/\u03c1RED < 1.1)", Color.YELLOW, 0.5);
        }
    }

    private void copyMetadata(Product partProduct, Product targetProduct, String name) {
        MetadataElement header = partProduct.getMetadataRoot().getElement("Header");
        header.setName(name);
        targetProduct.getMetadataRoot().addElement(header);
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("should be read from source images only");
    }

    private static enum FileType {
        RAD,
        GEOM,
        GEOM_PRECISE,
        RGB,
        NDVI,
        FLAG;


        static FileType fromString(String fileType) {
            if (fileType.equalsIgnoreCase("hico")) {
                return RAD;
            }
            if (fileType.equalsIgnoreCase("hico_rad_geom")) {
                return GEOM;
            }
            if (fileType.equalsIgnoreCase("hico_LonLatViewAngles")) {
                return GEOM_PRECISE;
            }
            if (fileType.equalsIgnoreCase("hico_rad_rgb")) {
                return RGB;
            }
            if (fileType.equalsIgnoreCase("hico_rad_ndvi")) {
                return NDVI;
            }
            if (fileType.equalsIgnoreCase("hico_rad_flag")) {
                return FLAG;
            }
            throw new IllegalArgumentException("Unkown File type: " + fileType);
        }
    }
}

