/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.hico;

import java.io.File;
import java.util.Locale;
import org.esa.beam.dataio.hico.HicoFilename;
import org.esa.beam.dataio.hico.HicoProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class HicoProductReaderPlugin
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        File[] hdrFiles = HicoProductReaderPlugin.findHdrFiles(input);
        if (hdrFiles.length > 0) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public String[] getFormatNames() {
        return new String[]{"HICO"};
    }

    public ProductReader createReaderInstance() {
        return new HicoProductReader(this);
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".hdr"};
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale locale) {
        return "HICO Data Products";
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null)){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName();
                return fileName.startsWith("iss.") && fileName.endsWith(".hico.hdr");
            }
        };
    }

    static File[] findHdrFiles(Object input) {
        File file;
        String fileName;
        HicoFilename hicoFilename;
        if (input != null && (hicoFilename = HicoFilename.create(fileName = (file = new File(input.toString())).getName())) != null) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                parentFile = new File(".");
            }
            return hicoFilename.findAllHdrs(parentFile);
        }
        return new File[0];
    }
}

