/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.descriptor;

import com.bc.ceres.core.Assert;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.framework.gpf.descriptor.TargetProductDescriptor;

public class AnnotationTargetProductDescriptor
implements TargetProductDescriptor {
    private final String name;
    private final TargetProduct annotation;

    public AnnotationTargetProductDescriptor(String name, TargetProduct annotation) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)annotation, (String)"annotation");
        this.name = name;
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TargetProduct getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getAlias() {
        return "target";
    }

    @Override
    public String getLabel() {
        return AnnotationTargetProductDescriptor.getNonEmptyStringOrNull(this.annotation.label());
    }

    @Override
    public String getDescription() {
        return AnnotationTargetProductDescriptor.getNonEmptyStringOrNull(this.annotation.description());
    }

    @Override
    public Class<? extends Product> getDataType() {
        return Product.class;
    }

    private static String getNonEmptyStringOrNull(String label) {
        return label == null || label.isEmpty() ? null : label;
    }
}

