/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.descriptor;

import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.descriptor.AnnotationParameterDescriptor;
import org.esa.beam.framework.gpf.descriptor.ParameterDescriptor;
import org.esa.beam.util.StringUtils;

public class DefaultParameterDescriptor
implements ParameterDescriptor {
    String name;
    String alias;
    Class<?> dataType;
    String defaultValue;
    String description;
    String label;
    String unit;
    String interval;
    String[] valueSet;
    String condition;
    String pattern;
    String format;
    Boolean notNull;
    Boolean notEmpty;
    Class<? extends RasterDataNode> rasterDataNodeClass;
    Class<? extends Validator> validatorClass;
    Class<? extends com.bc.ceres.binding.Converter> converterClass;
    Class<? extends DomConverter> domConverterClass;
    String itemAlias;
    Boolean deprecated;

    public DefaultParameterDescriptor() {
    }

    public DefaultParameterDescriptor(String name, Class<?> dataType) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull(dataType, (String)"dataType");
        this.name = name;
        this.dataType = dataType;
        this.valueSet = new String[0];
    }

    private Object readResolve() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(Class<?> dataType) {
        this.dataType = dataType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Override
    public String[] getValueSet() {
        return this.valueSet != null ? this.valueSet : new String[]{};
    }

    public void setValueSet(String[] valueSet) {
        this.valueSet = valueSet;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull != null ? this.notNull : false;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    @Override
    public boolean isNotEmpty() {
        return this.notEmpty != null ? this.notEmpty : false;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated != null ? this.deprecated : false;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    @Override
    public Class<? extends RasterDataNode> getRasterDataNodeClass() {
        return this.rasterDataNodeClass;
    }

    public void setRasterDataNodeClass(Class<? extends RasterDataNode> rasterDataNodeClass) {
        this.rasterDataNodeClass = rasterDataNodeClass;
    }

    @Override
    public Class<? extends Validator> getValidatorClass() {
        return this.validatorClass;
    }

    public void setValidatorClass(Class<? extends Validator> validator) {
        this.validatorClass = validator;
    }

    @Override
    public Class<? extends com.bc.ceres.binding.Converter> getConverterClass() {
        return this.converterClass;
    }

    public void setConverterClass(Class<? extends com.bc.ceres.binding.Converter> converter) {
        this.converterClass = converter;
    }

    @Override
    public Class<? extends DomConverter> getDomConverterClass() {
        return this.domConverterClass;
    }

    public void setDomConverterClass(Class<? extends DomConverter> domConverter) {
        this.domConverterClass = domConverter;
    }

    @Override
    public String getItemAlias() {
        return this.itemAlias;
    }

    public void setItemAlias(String itemAlias) {
        this.itemAlias = itemAlias;
    }

    @Override
    public boolean isStructure() {
        return DefaultParameterDescriptor.isStructure(this.getDataType());
    }

    @Override
    public ParameterDescriptor[] getStructureMemberDescriptors() {
        return DefaultParameterDescriptor.getDataMemberDescriptors(this.getDataType());
    }

    public static boolean isStructure(Class<?> type) {
        return !DefaultParameterDescriptor.isSimple(type) && !type.isArray();
    }

    public static boolean isSimple(Class<?> type) {
        return type.isPrimitive() || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || ConverterRegistry.getInstance().getConverter(type) != null;
    }

    public static ParameterDescriptor[] getDataMemberDescriptors(Class<?> dataType) {
        Field[] declaredFields;
        if (!DefaultParameterDescriptor.isStructure(dataType)) {
            return new ParameterDescriptor[0];
        }
        ArrayList<ParameterDescriptor> parameterDescriptors = new ArrayList<ParameterDescriptor>();
        for (Field declaredField : declaredFields = dataType.getDeclaredFields()) {
            int modifiers = declaredField.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
            Parameter annotation = declaredField.getAnnotation(Parameter.class);
            if (annotation != null) {
                boolean isDeprecated = declaredField.getAnnotation(Deprecated.class) != null;
                parameterDescriptors.add(new AnnotationParameterDescriptor(declaredField.getName(), declaredField.getType(), isDeprecated, annotation));
                continue;
            }
            parameterDescriptors.add(new DefaultParameterDescriptor(declaredField.getName(), declaredField.getType()));
        }
        return parameterDescriptors.toArray(new ParameterDescriptor[parameterDescriptors.size()]);
    }

    public static class XStreamConverter
    implements Converter {
        public boolean canConvert(Class aClass) {
            return DefaultParameterDescriptor.class.equals((Object)aClass);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            DefaultParameterDescriptor headerParameter = (DefaultParameterDescriptor)source;
            writer.addAttribute("name", headerParameter.getName());
            writer.addAttribute("dataType", headerParameter.getDataType().toString());
            writer.addAttribute("defaultValue", headerParameter.getDefaultValue());
            writer.addAttribute("description", headerParameter.getDescription());
            writer.addAttribute("label", headerParameter.getLabel());
            writer.addAttribute("unit", headerParameter.getUnit());
            writer.addAttribute("interval", headerParameter.getInterval());
            writer.addAttribute("valueSet", StringUtils.arrayToString((Object)headerParameter.getValueSet(), (String)","));
            writer.addAttribute("condition", headerParameter.getCondition());
            writer.addAttribute("pattern", headerParameter.getPattern());
            writer.addAttribute("format", headerParameter.getFormat());
            writer.addAttribute("notNull", String.valueOf(headerParameter.isNotNull()));
            writer.addAttribute("notEmpty", String.valueOf(headerParameter.isNotEmpty()));
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            DefaultParameterDescriptor headerParameter = new DefaultParameterDescriptor();
            try {
                headerParameter.setDataType(Class.forName(reader.getAttribute("dataType")));
            }
            catch (ClassNotFoundException e) {
                throw new ConversionException((Throwable)e);
            }
            headerParameter.setName(reader.getAttribute("name"));
            headerParameter.setDefaultValue(reader.getAttribute("defaultValue"));
            headerParameter.setDescription(reader.getAttribute("description"));
            headerParameter.setLabel(reader.getAttribute("label"));
            headerParameter.setUnit(reader.getAttribute("unit"));
            headerParameter.setInterval(reader.getAttribute("interval"));
            String valueSetString = reader.getAttribute("valueSet");
            if (valueSetString != null) {
                headerParameter.setValueSet(StringUtils.toStringArray((String)valueSetString, (String)","));
            }
            headerParameter.setCondition(reader.getAttribute("condition"));
            headerParameter.setPattern(reader.getAttribute("pattern"));
            headerParameter.setFormat(reader.getAttribute("format"));
            headerParameter.setNotNull(Boolean.parseBoolean(reader.getAttribute("notNull")));
            headerParameter.setNotEmpty(Boolean.parseBoolean(reader.getAttribute("notEmpty")));
            return headerParameter;
        }
    }
}

