/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

import com.bc.ceres.binding.dom.DomElement;
import java.util.Set;
import org.esa.beam.framework.gpf.Operator;

public class OperatorConfiguration {
    private final DomElement configuration;
    private final Set<Reference> referenceSet;

    public OperatorConfiguration(DomElement configuration, Set<Reference> references) {
        this.configuration = configuration;
        this.referenceSet = references;
    }

    public DomElement getConfiguration() {
        return this.configuration;
    }

    public Set<Reference> getReferenceSet() {
        return this.referenceSet;
    }

    public static class ParameterReference
    implements Reference {
        private final String name;
        private final Object value;

        public ParameterReference(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getParameterName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class PropertyReference
    implements Reference {
        final String parameterName;
        final String propertyName;
        final Operator operator;

        public PropertyReference(String parameterName, String propertyName, Operator operator) {
            this.parameterName = parameterName;
            this.propertyName = propertyName;
            this.operator = operator;
        }

        @Override
        public Object getValue() {
            return this.operator.getTargetProperty(this.propertyName);
        }

        @Override
        public String getParameterName() {
            return this.parameterName;
        }
    }

    public static interface Reference {
        public Object getValue();

        public String getParameterName();
    }
}

