/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingListener;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.internal.OperatorContext;
import org.esa.beam.framework.gpf.internal.OperatorImage;
import org.esa.beam.framework.gpf.internal.StdOutProgressMonitor;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.beam.util.math.MathUtils;

public class OperatorExecutor {
    private final int tileCountX;
    private final int tileCountY;
    private final PlanarImage[] images;
    private final TileScheduler tileScheduler;
    private final int parallelism;
    private volatile OperatorException error = null;
    private boolean scheduleRowsSeparate = false;

    public static OperatorExecutor create(Operator op) {
        OperatorContext operatorContext = OperatorExecutor.getOperatorContext(op);
        Product targetProduct = op.getTargetProduct();
        Dimension tileSize = targetProduct.getPreferredTileSize();
        int rasterHeight = targetProduct.getSceneRasterHeight();
        int rasterWidth = targetProduct.getSceneRasterWidth();
        Rectangle boundary = new Rectangle(rasterWidth, rasterHeight);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Band[] targetBands = targetProduct.getBands();
        PlanarImage[] images = OperatorExecutor.createImages(targetBands, operatorContext);
        return new OperatorExecutor(images, tileCountX, tileCountY);
    }

    public OperatorExecutor(PlanarImage[] images, int tileCountX, int tileCountY) {
        this(images, tileCountX, tileCountY, JAI.getDefaultInstance().getTileScheduler().getParallelism());
    }

    public OperatorExecutor(PlanarImage[] images, int tileCountX, int tileCountY, int parallelism) {
        this.images = images;
        this.tileCountX = tileCountX;
        this.tileCountY = tileCountY;
        this.parallelism = parallelism;
        this.tileScheduler = JAI.getDefaultInstance().getTileScheduler();
    }

    public void setScheduleRowsSeparate(boolean scheduleRowsSeparate) {
        this.scheduleRowsSeparate = scheduleRowsSeparate;
    }

    public void execute(ProgressMonitor pm) {
        this.execute(ExecutionOrder.SCHEDULE_ROW_BAND_COLUMN, pm);
    }

    public void execute(ExecutionOrder executionOrder, ProgressMonitor pm) {
        this.execute(executionOrder, "Executing operator...", pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionOrder executionOrder, String executionMessage, ProgressMonitor pm) {
        Semaphore semaphore = new Semaphore(this.parallelism, true);
        OperatorTileComputationListener tcl = new OperatorTileComputationListener(semaphore, pm);
        TileComputationListener[] listeners = new TileComputationListener[]{tcl};
        ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
        JAI.getDefaultInstance().setImagingListener((ImagingListener)new GPFImagingListener());
        pm.beginTask(executionMessage, this.tileCountX * this.tileCountY * this.images.length);
        ExecutionOrder effectiveExecutionOrder = this.getEffectiveExecutionOrder(executionOrder);
        try {
            if (effectiveExecutionOrder == ExecutionOrder.SCHEDULE_ROW_BAND_COLUMN) {
                this.scheduleRowBandColumn(semaphore, listeners, pm);
            } else if (effectiveExecutionOrder == ExecutionOrder.SCHEDULE_ROW_COLUMN_BAND) {
                this.scheduleRowColumnBand(semaphore, pm);
            } else if (effectiveExecutionOrder == ExecutionOrder.SCHEDULE_BAND_ROW_COLUMN) {
                this.scheduleBandRowColumn(semaphore, listeners, pm);
            } else if (effectiveExecutionOrder == ExecutionOrder.PULL_ROW_BAND_COLUMN) {
                this.executeRowBandColumn(pm);
            } else {
                throw new IllegalArgumentException("executionOrder");
            }
            OperatorExecutor.acquirePermits(semaphore, this.parallelism);
            if (this.error != null) {
                throw this.error;
            }
        }
        finally {
            semaphore.release(this.parallelism);
            pm.done();
            JAI.getDefaultInstance().setImagingListener(imagingListener);
        }
    }

    private ExecutionOrder getEffectiveExecutionOrder(ExecutionOrder executionOrder) {
        ExecutionOrder effectiveExecutionOrder = executionOrder;
        String executionOrderProperty = System.getProperty("beam.gpf.executionOrder");
        if (executionOrderProperty != null) {
            effectiveExecutionOrder = ExecutionOrder.valueOf(executionOrderProperty);
        }
        if (effectiveExecutionOrder != executionOrder) {
            BeamLogManager.getSystemLogger().info("Changing execution order from " + (Object)((Object)executionOrder) + " to " + (Object)((Object)effectiveExecutionOrder));
        }
        return effectiveExecutionOrder;
    }

    private void scheduleBandRowColumn(Semaphore semaphore, TileComputationListener[] listeners, ProgressMonitor pm) {
        for (PlanarImage image : this.images) {
            for (int tileY = 0; tileY < this.tileCountY; ++tileY) {
                for (int tileX = 0; tileX < this.tileCountX; ++tileX) {
                    this.scheduleTile(image, tileX, tileY, semaphore, listeners, pm);
                }
                if (!this.scheduleRowsSeparate) continue;
                OperatorExecutor.acquirePermits(semaphore, this.parallelism);
                semaphore.release(this.parallelism);
            }
        }
    }

    private void scheduleRowBandColumn(Semaphore semaphore, TileComputationListener[] listeners, ProgressMonitor pm) {
        StdOutProgressMonitor stdOutPM = new StdOutProgressMonitor(this.tileCountY);
        for (int tileY = 0; tileY < this.tileCountY; ++tileY) {
            for (PlanarImage image : this.images) {
                for (int tileX = 0; tileX < this.tileCountX; ++tileX) {
                    this.scheduleTile(image, tileX, tileY, semaphore, listeners, pm);
                }
            }
            if (pm == ProgressMonitor.NULL) {
                stdOutPM.worked(tileY);
            }
            if (!this.scheduleRowsSeparate) continue;
            OperatorExecutor.acquirePermits(semaphore, this.parallelism);
            semaphore.release(this.parallelism);
        }
        if (pm == ProgressMonitor.NULL) {
            stdOutPM.done();
        }
    }

    private void scheduleRowColumnBand(Semaphore semaphore, ProgressMonitor pm) {
        if (this.images.length >= 1) {
            OperatorTileComputationListenerStack tcl = new OperatorTileComputationListenerStack(semaphore, this.images, pm);
            TileComputationListener[] listeners = new TileComputationListener[]{tcl};
            StdOutProgressMonitor stdOutPM = new StdOutProgressMonitor(this.tileCountY);
            for (int tileY = 0; tileY < this.tileCountY; ++tileY) {
                for (int tileX = 0; tileX < this.tileCountX; ++tileX) {
                    this.scheduleTile(this.images[0], tileX, tileY, semaphore, listeners, pm);
                }
                if (pm == ProgressMonitor.NULL) {
                    stdOutPM.worked(tileY);
                }
                if (!this.scheduleRowsSeparate) continue;
                OperatorExecutor.acquirePermits(semaphore, this.parallelism);
                semaphore.release(this.parallelism);
            }
            if (pm == ProgressMonitor.NULL) {
                stdOutPM.done();
            }
        }
    }

    private void scheduleTile(PlanarImage image, int tileX, int tileY, Semaphore semaphore, TileComputationListener[] listeners, ProgressMonitor pm) {
        BeamLogManager.getSystemLogger().finest(String.format("Scheduling tile x=%d/%d y=%d/%d for %s", tileX + 1, this.tileCountX, tileY + 1, this.tileCountY, image));
        OperatorExecutor.checkForCancelation(pm);
        OperatorExecutor.acquirePermits(semaphore, 1);
        if (this.error != null) {
            semaphore.release(this.parallelism);
            throw this.error;
        }
        Point[] points = new Point[]{new Point(tileX, tileY)};
        this.tileScheduler.scheduleTiles(image, points, listeners);
    }

    private static void acquirePermits(Semaphore semaphore, int permits) {
        try {
            semaphore.acquire(permits);
        }
        catch (InterruptedException e) {
            throw new OperatorException(e);
        }
    }

    private static OperatorContext getOperatorContext(Operator operator) {
        try {
            Field field = Operator.class.getDeclaredField("context");
            field.setAccessible(true);
            OperatorContext operatorContext = (OperatorContext)field.get(operator);
            field.setAccessible(false);
            return operatorContext;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static PlanarImage[] createImages(Band[] targetBands, OperatorContext operatorContext) {
        ArrayList<OperatorImage> images = new ArrayList<OperatorImage>(targetBands.length);
        for (Band band : targetBands) {
            OperatorImage operatorImage = operatorContext.getTargetImage(band);
            if (operatorImage == null) continue;
            images.add(operatorImage);
        }
        return images.toArray(new PlanarImage[images.size()]);
    }

    private static void checkForCancelation(ProgressMonitor pm) {
        if (pm.isCanceled()) {
            throw new OperatorException("Operation canceled.");
        }
    }

    private void executeRowBandColumn(ProgressMonitor pm) {
        for (int tileY = 0; tileY < this.tileCountY; ++tileY) {
            for (PlanarImage image : this.images) {
                for (int tileX = 0; tileX < this.tileCountX; ++tileX) {
                    OperatorExecutor.checkForCancelation(pm);
                    image.getTile(tileX, tileY);
                    pm.worked(1);
                }
            }
        }
    }

    private class GPFImagingListener
    implements ImagingListener {
        private GPFImagingListener() {
        }

        public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
            if (OperatorExecutor.this.error == null && !thrown.getClass().getSimpleName().equals("MediaLibLoadException")) {
                OperatorExecutor.this.error = new OperatorException(thrown);
            }
            return false;
        }
    }

    private class OperatorTileComputationListener
    implements TileComputationListener {
        private final Semaphore semaphore;
        private final ProgressMonitor pm;

        OperatorTileComputationListener(Semaphore semaphore, ProgressMonitor pm) {
            this.semaphore = semaphore;
            this.pm = pm;
        }

        public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster raster) {
            this.semaphore.release();
            this.pm.worked(1);
        }

        public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation cancelled.");
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }

        public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable situation) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation failed.", situation);
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }
    }

    private class OperatorTileComputationListenerStack
    implements TileComputationListener {
        private final Semaphore semaphore;
        private final PlanarImage[] images;
        private final ProgressMonitor pm;

        OperatorTileComputationListenerStack(Semaphore semaphore, PlanarImage[] images, ProgressMonitor pm) {
            this.semaphore = semaphore;
            this.images = images;
            this.pm = pm;
        }

        public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster raster) {
            for (PlanarImage planarImage : this.images) {
                if (image != planarImage) {
                    BeamLogManager.getSystemLogger().finest(String.format("Scheduling tile x=%d/%d y=%d/%d for %s", tileX + 1, OperatorExecutor.this.tileCountX, tileY + 1, OperatorExecutor.this.tileCountY, planarImage));
                    planarImage.getTile(tileX, tileY);
                }
                this.pm.worked(1);
            }
            this.semaphore.release();
        }

        public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation cancelled.");
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }

        public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable situation) {
            if (OperatorExecutor.this.error == null) {
                OperatorExecutor.this.error = new OperatorException("Operation failed.", situation);
            }
            this.semaphore.release(OperatorExecutor.this.parallelism);
        }
    }

    public static enum ExecutionOrder {
        SCHEDULE_ROW_COLUMN_BAND,
        SCHEDULE_ROW_BAND_COLUMN,
        SCHEDULE_BAND_ROW_COLUMN,
        PULL_ROW_BAND_COLUMN;

    }
}

