/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.Locale;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.internal.OperatorContext;
import org.esa.beam.framework.gpf.internal.OperatorImage;
import org.esa.beam.util.io.BeamFileFilter;

public class OperatorProductReader
implements ProductReader {
    private static PlugIn plugIn = new PlugIn();
    private OperatorContext operatorContext;

    public OperatorProductReader(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public Object getInput() {
        return this.operatorContext.getSourceProducts();
    }

    public ProductReaderPlugIn getReaderPlugIn() {
        return plugIn;
    }

    public ProductSubsetDef getSubsetDef() {
        return null;
    }

    public Product readProductNodes(Object input, ProductSubsetDef subsetDef) throws IOException {
        try {
            return this.operatorContext.getTargetProduct();
        }
        catch (OperatorException e) {
            throw new IOException(e);
        }
    }

    public void readBandRasterData(Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        this.operatorContext.getLogger().warning("OperatorProductReader.readBandRasterData: Should not come here anymore since raster data shall only be computed by OperatorImage");
        OperatorImage image = this.operatorContext.getTargetImage(destBand);
        Raster data = image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
        data.getDataElements(destOffsetX, destOffsetY, destWidth, destHeight, destBuffer.getElems());
    }

    public synchronized void close() throws IOException {
        if (this.operatorContext != null && !this.operatorContext.isDisposed()) {
            this.operatorContext.dispose();
            this.operatorContext = null;
        }
    }

    public String toString() {
        return "OperatorProductReader[op=" + this.operatorContext.getOperator().getClass().getSimpleName() + "]";
    }

    private static class PlugIn
    implements ProductReaderPlugIn {
        private PlugIn() {
        }

        public DecodeQualification getDecodeQualification(Object input) {
            return input instanceof OperatorContext ? DecodeQualification.INTENDED : DecodeQualification.UNABLE;
        }

        public ProductReader createReaderInstance() {
            throw new RuntimeException("not implemented");
        }

        public Class[] getInputTypes() {
            return new Class[]{OperatorContext.class};
        }

        public String[] getDefaultFileExtensions() {
            return new String[0];
        }

        public String getDescription(Locale locale) {
            return "Adapts an Operator to a ProductReader";
        }

        public String[] getFormatNames() {
            return new String[]{"GPF_IN_MEMORY"};
        }

        public BeamFileFilter getProductFileFilter() {
            return null;
        }
    }
}

