/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.internal;

public final class StdOutProgressMonitor {
    private final int minorStep = 2;
    private final int majorStep = 10;
    private int lastMinPercentComplete = 2;
    private int lastMajPercentComplete = 10;
    private final int max;
    private boolean percentWritten = false;

    public StdOutProgressMonitor(int max) {
        this.max = max;
    }

    public void worked(int tileY) {
        int percentComplete = (int)((float)tileY / (float)this.max * 100.0f);
        if (percentComplete > this.lastMinPercentComplete) {
            this.lastMinPercentComplete = percentComplete / 2 * 2 + 2;
            if (percentComplete > this.lastMajPercentComplete) {
                System.out.print(this.lastMajPercentComplete + "%");
                this.lastMajPercentComplete = percentComplete / 10 * 10 + 10;
                this.percentWritten = true;
            } else {
                System.out.print(".");
            }
        }
    }

    public void done() {
        if (this.percentWritten) {
            System.out.println("100%");
        }
    }
}

