/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.main;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.util.io.FileUtils;

public class CommandLineArgs {
    private static final int K = 1024;
    private static final int M = 0x100000;
    private static final int G = 0x40000000;
    public static final String DEFAULT_TARGET_FILEPATH = "target.dim";
    public static final String DEFAULT_METADATA_FILEPATH = "metadata.properties";
    public static final String DEFAULT_VELOCITY_TEMPLATE_DIRPATH = ".";
    public static final String DEFAULT_FORMAT_NAME = "BEAM-DIMAP";
    public static final int DEFAULT_TILE_CACHE_SIZE_IN_M = 512;
    public static final int DEFAULT_TILE_SCHEDULER_PARALLELISM = Runtime.getRuntime().availableProcessors();
    public static final String VELOCITY_TEMPLATE_EXTENSION = ".vm";
    private String[] args;
    private String operatorName;
    private String graphFilePath;
    private String targetFilePath;
    private TreeMap<String, String> parameterMap;
    private TreeMap<String, String> sourceFilePathMap;
    private String targetFormatName;
    private String parameterFilePath;
    private String metadataFilePath;
    private String velocityTemplateDirPath;
    private TreeMap<String, String> targetFilePathMap;
    private boolean helpRequested;
    private String inFolderPath = null;
    private boolean printAllHelp = false;
    private boolean stackTraceDump;
    private boolean clearCacheAfterRowWrite;
    private long tileCacheCapacity;
    private int tileSchedulerParallelism;

    public static CommandLineArgs parseArgs(String ... args) throws Exception {
        CommandLineArgs lineArgs = new CommandLineArgs(args);
        lineArgs.parseArgs();
        return lineArgs;
    }

    private CommandLineArgs(String[] args) {
        this.args = (String[])args.clone();
        if (this.args.length == 0) {
            this.helpRequested = true;
        }
        this.sourceFilePathMap = new TreeMap();
        this.targetFilePathMap = new TreeMap();
        this.parameterMap = new TreeMap();
        this.tileCacheCapacity = 0x20000000L;
        this.tileSchedulerParallelism = DEFAULT_TILE_SCHEDULER_PARALLELISM;
        this.stackTraceDump = CommandLineArgs.isStackTraceDumpEnabled(args);
    }

    static boolean isStackTraceDumpEnabled(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-e")) continue;
            return true;
        }
        return false;
    }

    private void parseArgs() throws Exception {
        int argCount = 0;
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (arg.startsWith("-")) {
                if (arg.startsWith("-P")) {
                    String[] pair = this.parseNameValuePair(arg);
                    this.parameterMap.put(pair[0], pair[1]);
                    continue;
                }
                if (arg.startsWith("-S")) {
                    String[] pair = this.parseNameValuePair(arg);
                    this.sourceFilePathMap.put(pair[0], pair[1]);
                    continue;
                }
                if (arg.startsWith("-T")) {
                    String[] pair = this.parseNameValuePair(arg);
                    this.targetFilePathMap.put(pair[0], pair[1]);
                    continue;
                }
                if (arg.equals("-h")) {
                    this.helpRequested = true;
                    continue;
                }
                if (arg.equals("-printHelp")) {
                    this.printAllHelp = true;
                    continue;
                }
                if (arg.equals("-x")) {
                    this.clearCacheAfterRowWrite = true;
                    continue;
                }
                if (arg.equals("-e")) continue;
                if (arg.equals("-t")) {
                    this.targetFilePath = this.parseOptionArgument(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-f")) {
                    this.targetFormatName = this.parseOptionArgument(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-p")) {
                    this.parameterFilePath = this.parseOptionArgument(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-m")) {
                    this.metadataFilePath = this.parseOptionArgument(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-v")) {
                    this.velocityTemplateDirPath = this.parseOptionArgument(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-q")) {
                    this.tileSchedulerParallelism = this.parseOptionArgumentInt(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-c")) {
                    this.tileCacheCapacity = this.parseOptionArgumentBytes(arg, i);
                    ++i;
                    continue;
                }
                if (arg.equals("-inFolder")) {
                    this.inFolderPath = this.parseOptionArgument(arg, i);
                    ++i;
                    continue;
                }
                throw CommandLineArgs.error("Unknown option '" + arg + "'");
            }
            if (argCount == 0) {
                if (arg.endsWith(".xml") || arg.endsWith(".XML") || arg.contains("/") || arg.contains("\\")) {
                    this.graphFilePath = arg;
                } else {
                    this.operatorName = arg;
                }
            } else {
                int index = argCount - 1;
                if (index == 0) {
                    this.sourceFilePathMap.put("sourceProduct", arg);
                }
                this.sourceFilePathMap.put("sourceProduct." + (index + 1), arg);
                this.sourceFilePathMap.put("sourceProduct" + (index + 1), arg);
            }
            ++argCount;
        }
        if (this.operatorName == null && this.graphFilePath == null && !this.helpRequested) {
            throw CommandLineArgs.error("Either operator name or graph XML file must be given");
        }
        if (this.graphFilePath == null && !this.targetFilePathMap.isEmpty()) {
            throw CommandLineArgs.error("Defined target products only valid for graph XML");
        }
        if (this.metadataFilePath != null && this.metadataFilePath.isEmpty()) {
            this.metadataFilePath = null;
        }
        if (this.velocityTemplateDirPath != null && this.velocityTemplateDirPath.isEmpty()) {
            this.velocityTemplateDirPath = null;
        }
        if (this.targetFilePath == null && this.targetFilePathMap.isEmpty()) {
            this.targetFilePath = DEFAULT_TARGET_FILEPATH;
        }
        if (this.targetFormatName == null && this.targetFilePath != null) {
            String extension = FileUtils.getExtension((String)this.targetFilePath);
            if (extension == null || extension.isEmpty()) {
                this.targetFormatName = DEFAULT_FORMAT_NAME;
            } else {
                this.targetFormatName = this.detectWriterFormat(extension);
                if (this.targetFormatName == null) {
                    throw CommandLineArgs.error("Output format unknown");
                }
            }
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getGraphFilePath() {
        return this.graphFilePath;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public String getTargetFormatName() {
        return this.targetFormatName;
    }

    public String getMetadataFilePath() {
        return this.metadataFilePath;
    }

    public String getVelocityTemplateDirPath() {
        return this.velocityTemplateDirPath;
    }

    public String getInFolderPath() {
        return this.inFolderPath;
    }

    public String getParameterFilePath() {
        return this.parameterFilePath;
    }

    public long getTileCacheCapacity() {
        return this.tileCacheCapacity;
    }

    public int getTileSchedulerParallelism() {
        return this.tileSchedulerParallelism;
    }

    public boolean isClearCacheAfterRowWrite() {
        return this.clearCacheAfterRowWrite;
    }

    public SortedMap<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public SortedMap<String, String> getSourceFilePathMap() {
        return this.sourceFilePathMap;
    }

    public SortedMap<String, String> getTargetFilePathMap() {
        return this.targetFilePathMap;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public boolean isPrintAllHelpRequested() {
        return this.printAllHelp;
    }

    public boolean isStackTraceDump() {
        return this.stackTraceDump;
    }

    private String parseOptionArgument(String arg, int index) throws Exception {
        if (index < this.args.length - 1) {
            return this.args[index + 1];
        }
        throw CommandLineArgs.error("Missing argument for option '" + arg + "'");
    }

    private int parseOptionArgumentInt(String arg, int index) throws Exception {
        String valueString = this.parseOptionArgument(arg, index);
        return Integer.parseInt(valueString);
    }

    private long parseOptionArgumentBytes(String arg, int index) throws Exception {
        String valueString = this.parseOptionArgument(arg, index);
        long factor = 1L;
        if (valueString.toUpperCase().endsWith("K")) {
            factor = 1024L;
            valueString = valueString.substring(0, valueString.length() - 1);
        } else if (valueString.toUpperCase().endsWith("M")) {
            factor = 0x100000L;
            valueString = valueString.substring(0, valueString.length() - 1);
        } else if (valueString.toUpperCase().endsWith("G")) {
            factor = 0x40000000L;
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        long value = Long.parseLong(valueString);
        if (value < 0L) {
            throw CommandLineArgs.error(MessageFormat.format("Value for ''{0}'' must not be negative", arg));
        }
        return factor * value;
    }

    private String[] parseNameValuePair(String arg) throws Exception {
        int pos = arg.indexOf(61);
        if (pos == -1) {
            throw CommandLineArgs.error("Missing '=' in '" + arg + "'");
        }
        String name = arg.substring(2, pos).trim();
        if (name.isEmpty()) {
            throw CommandLineArgs.error("Empty identifier in '" + arg + "'");
        }
        String value = arg.substring(pos + 1).trim();
        return new String[]{name, value};
    }

    private String detectWriterFormat(String extension) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator ins = registry.getAllWriterPlugIns();
        while (ins.hasNext()) {
            String[] strings;
            ProductWriterPlugIn productWriterPlugIn = (ProductWriterPlugIn)ins.next();
            for (String string : strings = productWriterPlugIn.getDefaultFileExtensions()) {
                if (!string.equalsIgnoreCase(extension)) continue;
                return productWriterPlugIn.getFormatNames()[0];
            }
        }
        return null;
    }

    private static Exception error(String m) {
        return new Exception(m);
    }
}

