/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.main;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.graph.Graph;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.gpf.graph.Node;
import org.esa.beam.framework.gpf.graph.NodeSource;
import org.esa.beam.gpf.operators.standard.ReadOp;

public class ProductSetHandler {
    private final Graph graph;
    private static final String PRODUCT_SET_READER_NAME = "ProductSet-Reader";
    private static final String SEPARATOR = ",";
    private static final String SEPARATOR_ESC = "\\u002C";

    public ProductSetHandler(Graph graph) {
        this.graph = graph;
    }

    public ProductSetData[] findProductSetStacks(String fileListPath) throws GraphException {
        ArrayList<ProductSetData> productSetDataList = new ArrayList<ProductSetData>();
        for (Node n : this.graph.getNodes()) {
            File inputFolder;
            if (!n.getOperatorName().equalsIgnoreCase(PRODUCT_SET_READER_NAME)) continue;
            ProductSetData psData = new ProductSetData(n);
            boolean usingFileListPath = false;
            if (fileListPath != null && (inputFolder = new File(fileListPath)).isDirectory() && inputFolder.exists()) {
                usingFileListPath = true;
            }
            if (!usingFileListPath) {
                DomElement[] params;
                DomElement config = n.getConfiguration();
                for (DomElement p : params = (DomElement[])config.getChildren()) {
                    if (!p.getName().equals("fileList")) continue;
                    if (p.getValue() == null) {
                        throw new GraphException("ProductSet-Reader fileList is empty");
                    }
                    StringTokenizer st = new StringTokenizer(p.getValue(), SEPARATOR);
                    int length = st.countTokens();
                    for (int i = 0; i < length; ++i) {
                        String str = st.nextToken().replace(SEPARATOR_ESC, SEPARATOR).trim();
                        psData.fileList.add(str);
                    }
                    break;
                }
            }
            if (psData.fileList.size() == 0) {
                throw new GraphException("no input products found in " + fileListPath);
            }
            productSetDataList.add(psData);
        }
        return productSetDataList.toArray(new ProductSetData[productSetDataList.size()]);
    }

    public void replaceAllProductSets(ProductSetData[] productSetDataList) throws GraphException {
        int cnt = 0;
        for (ProductSetData psData : productSetDataList) {
            Node psNode = this.graph.getNode(psData.getNodeID());
            for (String filePath : psData.fileList) {
                ProductSetHandler.ReplaceProductSetWithReaders(this.graph, psNode, "inserted--" + psNode.getId() + "--" + cnt++, filePath);
            }
            if (psData.fileList.isEmpty()) continue;
            for (Node n : this.graph.getNodes()) {
                ProductSetHandler.disconnectNodeSource(n, psNode.getId());
            }
            this.graph.removeNode(psNode.getId());
        }
    }

    private static void ReplaceProductSetWithReaders(Graph graph, Node psNode, String id, String value) {
        Node newNode = new Node(id, OperatorSpi.getOperatorAlias(ReadOp.class));
        XppDomElement config = new XppDomElement("parameters");
        XppDomElement fileParam = new XppDomElement("file");
        fileParam.setValue(value);
        config.addChild((DomElement)fileParam);
        newNode.setConfiguration((DomElement)config);
        graph.addNode(newNode);
        ProductSetHandler.switchConnections(graph, newNode, psNode);
    }

    private static void switchConnections(Graph graph, Node newNode, Node oldNode) {
        for (Node n : graph.getNodes()) {
            if (!ProductSetHandler.isNodeSource(n, oldNode)) continue;
            NodeSource ns = new NodeSource("sourceProduct", newNode.getId());
            n.addSource(ns);
        }
    }

    private static void disconnectNodeSource(Node node, String id) {
        for (NodeSource ns : node.getSources()) {
            if (!ns.getSourceNodeId().equals(id)) continue;
            node.removeSource(ns);
        }
    }

    private static boolean isNodeSource(Node node, Node source) {
        NodeSource[] sources;
        for (NodeSource ns : sources = node.getSources()) {
            if (!ns.getSourceNodeId().equals(source.getId())) continue;
            return true;
        }
        return false;
    }

    static class ProductSetData {
        private final String nodeID;
        final ArrayList<String> fileList = new ArrayList();

        ProductSetData(Node n) {
            this.nodeID = n.getId();
        }

        public String getNodeID() {
            return this.nodeID;
        }
    }
}

