/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.pointop;

import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeFilter;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.util.ProductUtils;

public abstract class PointOperator
extends Operator {
    private transient RasterDataNode[] sourceNodes;
    private transient Band[] targetNodes;

    @Override
    public final void initialize() throws OperatorException {
        this.prepareInputs();
        Product targetProduct = this.createTargetProduct();
        this.setTargetProduct(targetProduct);
        this.configureTargetProduct(new ProductConfigurerImpl(this.getSourceProduct(), targetProduct));
        SourceSampleConfigurer sc = new SourceSampleConfigurer();
        TargetSampleConfigurer tc = new TargetSampleConfigurer();
        this.configureSourceSamples(sc);
        this.configureTargetSamples(tc);
        this.sourceNodes = sc.getNodes();
        this.targetNodes = tc.getNodes();
    }

    protected void prepareInputs() throws OperatorException {
        this.checkRasterSize();
    }

    protected Product createTargetProduct() throws OperatorException {
        Product sourceProduct = this.getSourceProduct();
        return new Product(this.getId(), this.getClass().getName(), sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight());
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        productConfigurer.copyTimeCoding();
        productConfigurer.copyTiePointGrids(new String[0]);
        productConfigurer.copyGeoCoding();
    }

    protected abstract void configureSourceSamples(SampleConfigurer var1) throws OperatorException;

    protected abstract void configureTargetSamples(SampleConfigurer var1) throws OperatorException;

    protected void checkRasterSize() throws OperatorException {
        Product[] sourceProducts = this.getSourceProducts();
        int w = 0;
        int h = 0;
        for (int i = 0; i < sourceProducts.length; ++i) {
            Product sourceProduct = sourceProducts[i];
            if (i == 0) {
                w = sourceProduct.getSceneRasterWidth();
                h = sourceProduct.getSceneRasterHeight();
                continue;
            }
            if (sourceProduct.getSceneRasterWidth() == w && sourceProduct.getSceneRasterHeight() == h) continue;
            throw new OperatorException("Source products must all have the same raster size.");
        }
    }

    Sample[] createSourceSamples(Rectangle targetRectangle, Point location) {
        Tile[] sourceTiles = this.getSourceTiles(targetRectangle);
        return PointOperator.createDefaultSamples(this.sourceNodes, sourceTiles, location);
    }

    WritableSample[] createTargetSamples(Map<Band, Tile> targetTileStack, Point location) {
        Tile[] targetTiles = this.getTargetTiles(targetTileStack);
        return PointOperator.createDefaultSamples((RasterDataNode[])this.targetNodes, targetTiles, location);
    }

    WritableSample createTargetSample(Tile targetTile, Point location) {
        RasterDataNode targetNode = targetTile.getRasterDataNode();
        for (int i = 0; i < this.targetNodes.length; ++i) {
            if (targetNode != this.targetNodes[i]) continue;
            return new WritableSampleImpl(i, targetTile, location);
        }
        String msgPattern = "Could not create target sample for band '%s'.";
        throw new IllegalStateException(String.format("Could not create target sample for band '%s'.", targetNode.getName()));
    }

    private Tile[] getSourceTiles(Rectangle region) {
        Tile[] sourceTiles = new Tile[this.sourceNodes.length];
        for (int i = 0; i < sourceTiles.length; ++i) {
            if (this.sourceNodes[i] == null) continue;
            sourceTiles[i] = this.getSourceTile(this.sourceNodes[i], region);
        }
        return sourceTiles;
    }

    private Tile[] getTargetTiles(Map<Band, Tile> targetTileStack) {
        Tile[] targetTiles = new Tile[this.targetNodes.length];
        for (int i = 0; i < targetTiles.length; ++i) {
            if (this.targetNodes[i] == null) continue;
            Tile targetTile = targetTileStack.get(this.targetNodes[i]);
            if (targetTile == null) {
                String msgPattern = "Could not find tile for defined target node '%s'.";
                throw new IllegalStateException(String.format("Could not find tile for defined target node '%s'.", this.targetNodes[i].getName()));
            }
            targetTiles[i] = targetTile;
        }
        return targetTiles;
    }

    private static WritableSampleImpl[] createDefaultSamples(RasterDataNode[] nodes, Tile[] tiles, Point location) {
        WritableSampleImpl[] samples = new WritableSampleImpl[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            samples[i] = nodes[i] != null ? new WritableSampleImpl(i, tiles[i], location) : WritableSampleImpl.NULL;
        }
        return samples;
    }

    private static final class ProductConfigurerImpl
    implements ProductConfigurer {
        private Product sourceProduct;
        private final Product targetProduct;

        private ProductConfigurerImpl(Product sourceProduct, Product targetProduct) {
            this.sourceProduct = sourceProduct;
            this.targetProduct = targetProduct;
        }

        @Override
        public Product getSourceProduct() {
            return this.sourceProduct;
        }

        @Override
        public void setSourceProduct(Product sourceProduct) {
            this.sourceProduct = sourceProduct;
        }

        @Override
        public Product getTargetProduct() {
            return this.targetProduct;
        }

        @Override
        public void copyMetadata() {
            ProductUtils.copyMetadata((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public void copyTimeCoding() {
            this.getTargetProduct().setStartTime(this.getSourceProduct().getStartTime());
            this.getTargetProduct().setEndTime(this.getSourceProduct().getEndTime());
        }

        @Override
        public void copyGeoCoding() {
            ProductUtils.copyGeoCoding((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public void copyMasks() {
            ProductUtils.copyMasks((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public void copyBands(String ... names) {
            if (names.length == 0) {
                names = this.getSourceProduct().getBandNames();
            }
            for (String name : names) {
                this.copyBand(name);
            }
        }

        @Override
        public void copyBands(ProductNodeFilter<Band> filter) {
            Band[] sourceBands;
            for (Band sourceBand : sourceBands = this.getSourceProduct().getBands()) {
                if (!filter.accept((ProductNode)sourceBand)) continue;
                this.copyBand(sourceBand.getName());
            }
        }

        @Override
        public void copyTiePointGrids(String ... names) {
            if (names.length == 0) {
                names = this.getSourceProduct().getTiePointGridNames();
            }
            for (String name : names) {
                ProductUtils.copyTiePointGrid((String)name, (Product)this.getSourceProduct(), (Product)this.getTargetProduct());
            }
        }

        @Override
        public void copyVectorData() {
            ProductUtils.copyVectorData((Product)this.getSourceProduct(), (Product)this.getTargetProduct());
        }

        @Override
        public Band addBand(String name, int dataType) {
            return this.getTargetProduct().addBand(name, dataType);
        }

        @Override
        public Band addBand(String name, int dataType, double noDataValue) {
            Band band = this.addBand(name, dataType);
            band.setNoDataValue(noDataValue);
            band.setNoDataValueUsed(true);
            return band;
        }

        @Override
        public Band addBand(String name, String expression) {
            return this.getTargetProduct().addBand(name, expression);
        }

        @Override
        public Band addBand(String name, String expression, double noDataValue) {
            Band band = this.addBand(name, expression);
            band.setNoDataValue(noDataValue);
            band.setNoDataValueUsed(true);
            return band;
        }

        private void copyBand(String name) {
            ProductUtils.copyBand((String)name, (Product)this.getSourceProduct(), (Product)this.getTargetProduct(), (boolean)true);
        }
    }

    private final class TargetSampleConfigurer
    extends AbstractSampleConfigurer<Band> {
        private TargetSampleConfigurer() {
        }

        @Override
        public void defineSample(int index, String name) {
            this.defineSample(index, name, PointOperator.this.getTargetProduct(), true);
        }

        @Override
        public void defineSample(int index, String name, Product product) {
            super.defineSample(index, name, product, true);
        }

        Band[] getNodes() {
            return this.nodes.toArray(new Band[this.nodes.size()]);
        }
    }

    private final class SourceSampleConfigurer
    extends AbstractSampleConfigurer<RasterDataNode> {
        private SourceSampleConfigurer() {
        }

        @Override
        public void defineSample(int index, String name) {
            this.defineSample(index, name, PointOperator.this.getSourceProduct(), false);
        }

        @Override
        public void defineSample(int index, String name, Product product) {
            super.defineSample(index, name, product, false);
        }
    }

    private static abstract class AbstractSampleConfigurer<T extends RasterDataNode>
    implements SampleConfigurer {
        final List<T> nodes = new ArrayList<T>();

        private AbstractSampleConfigurer() {
        }

        void defineSample(int index, String name, Product product, boolean sourceless) throws OperatorException {
            RasterDataNode node = product.getRasterDataNode(name);
            if (node == null) {
                String message = MessageFormat.format("Product ''{0}'' does not contain a raster data node with name ''{1}''", product.getName(), name);
                throw new OperatorException(message);
            }
            if (sourceless && node.isSourceImageSet()) {
                String message = MessageFormat.format("Raster data node ''{0}'' must be sourceless, since it is a computed target", name);
                throw new OperatorException(message);
            }
            if (index < this.nodes.size()) {
                this.nodes.set(index, node);
            } else if (index == this.nodes.size()) {
                this.nodes.add(node);
            } else {
                while (index > this.nodes.size()) {
                    this.nodes.add(null);
                }
                this.nodes.add(node);
            }
        }

        RasterDataNode[] getNodes() {
            return this.nodes.toArray(new RasterDataNode[this.nodes.size()]);
        }
    }

    private static final class WritableSampleImpl
    implements WritableSample {
        static final WritableSampleImpl NULL = new WritableSampleImpl();
        private final int index;
        private final RasterDataNode node;
        private final int dataType;
        private final Tile tile;
        private final Point location;

        private WritableSampleImpl(int index, Tile tile, Point location) {
            this.index = index;
            this.node = tile.getRasterDataNode();
            this.dataType = this.node.getGeophysicalDataType();
            this.tile = tile;
            this.location = location;
        }

        private WritableSampleImpl() {
            this.index = -1;
            this.node = null;
            this.dataType = -1;
            this.tile = null;
            this.location = null;
        }

        @Override
        public RasterDataNode getNode() {
            return this.node;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getDataType() {
            return this.dataType;
        }

        @Override
        public boolean getBit(int bitIndex) {
            return this.tile.getSampleBit(this.location.x, this.location.y, bitIndex);
        }

        @Override
        public boolean getBoolean() {
            return this.tile.getSampleBoolean(this.location.x, this.location.y);
        }

        @Override
        public int getInt() {
            return this.tile.getSampleInt(this.location.x, this.location.y);
        }

        @Override
        public float getFloat() {
            return this.tile.getSampleFloat(this.location.x, this.location.y);
        }

        @Override
        public double getDouble() {
            return this.tile.getSampleDouble(this.location.x, this.location.y);
        }

        @Override
        public void set(int bitIndex, boolean v) {
            this.tile.setSample(this.location.x, this.location.y, bitIndex, v);
        }

        @Override
        public void set(boolean v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }

        @Override
        public void set(int v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }

        @Override
        public void set(float v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }

        @Override
        public void set(double v) {
            this.tile.setSample(this.location.x, this.location.y, v);
        }
    }
}

