/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.ui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.experimental.Output;
import org.esa.beam.framework.gpf.internal.OperatorExecutor;
import org.esa.beam.framework.gpf.internal.OperatorProductReader;
import org.esa.beam.framework.gpf.ui.TargetProductSelector;
import org.esa.beam.framework.gpf.ui.TargetProductSelectorModel;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.ModelessDialog;
import org.esa.beam.framework.ui.SuppressibleOptionPane;
import org.esa.beam.gpf.operators.standard.WriteOp;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.FileUtils;

public abstract class SingleTargetProductDialog
extends ModelessDialog {
    protected TargetProductSelector targetProductSelector;
    protected AppContext appContext;

    protected SingleTargetProductDialog(AppContext appContext, String title, String helpID) {
        this(appContext, title, 152, helpID);
    }

    protected SingleTargetProductDialog(AppContext appContext, String title, int buttonMask, String helpID) {
        this(appContext, title, buttonMask, helpID, new TargetProductSelectorModel());
    }

    protected SingleTargetProductDialog(AppContext appContext, String title, int buttonMask, String helpID, TargetProductSelectorModel model) {
        this(appContext, title, buttonMask, helpID, model, false);
    }

    protected SingleTargetProductDialog(AppContext appContext, String title, int buttonMask, String helpID, TargetProductSelectorModel model, boolean alwaysWriteOutput) {
        super(appContext.getApplicationWindow(), title, buttonMask, helpID);
        this.appContext = appContext;
        this.targetProductSelector = new TargetProductSelector(model, alwaysWriteOutput);
        String homeDirPath = SystemUtils.getUserHomeDir().getPath();
        String saveDir = appContext.getPreferences().getPropertyString("app.file.lastSaveDir", homeDirPath);
        this.targetProductSelector.getModel().setProductDir(new File(saveDir));
        if (!alwaysWriteOutput) {
            this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + appContext.getApplicationName());
        }
        this.targetProductSelector.getModel().getValueContainer().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("saveToFileSelected") || evt.getPropertyName().equals("openInAppSelected")) {
                    SingleTargetProductDialog.this.updateRunButton();
                }
            }
        });
        AbstractButton button = this.getButton(8);
        button.setText("Run");
        button.setMnemonic('R');
        this.updateRunButton();
    }

    private void updateRunButton() {
        AbstractButton button = this.getButton(8);
        boolean save = this.targetProductSelector.getModel().isSaveToFileSelected();
        boolean open = this.targetProductSelector.getModel().isOpenInAppSelected();
        String toolTipText = "";
        boolean enabled = true;
        if (save && open) {
            toolTipText = "Save target product and open it in " + this.getAppContext().getApplicationName();
        } else if (save) {
            toolTipText = "Save target product";
        } else if (open) {
            toolTipText = "Open target product in " + this.getAppContext().getApplicationName();
        } else {
            enabled = false;
        }
        button.setToolTipText(toolTipText);
        button.setEnabled(enabled);
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public TargetProductSelector getTargetProductSelector() {
        return this.targetProductSelector;
    }

    protected void onApply() {
        if (!this.canApply()) {
            return;
        }
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        this.appContext.getPreferences().setPropertyString("app.file.lastSaveDir", productDir);
        Product targetProduct = null;
        try {
            targetProduct = this.createTargetProduct();
            if (targetProduct == null) {
                throw new NullPointerException("Target product is null.");
            }
        }
        catch (Throwable t) {
            this.handleInitialisationError(t);
        }
        if (targetProduct == null) {
            return;
        }
        targetProduct.setName(this.targetProductSelector.getModel().getProductName());
        if (this.targetProductSelector.getModel().isSaveToFileSelected()) {
            targetProduct.setFileLocation(this.targetProductSelector.getModel().getProductFile());
            ProductWriterSwingWorker worker = new ProductWriterSwingWorker(targetProduct);
            worker.executeWithBlocking();
        } else if (this.targetProductSelector.getModel().isOpenInAppSelected()) {
            this.appContext.getProductManager().addProduct(targetProduct);
            this.showOpenInAppInfo();
        }
    }

    protected void handleInitialisationError(Throwable t) {
        String msg = this.isInternalException(t) ? MessageFormat.format("An internal error occurred during the target product initialisation.\n{0}", this.formatThrowable(t)) : MessageFormat.format("A problem occurred during the target product initialisation.\n{0}", this.formatThrowable(t));
        this.appContext.handleError(msg, t);
    }

    protected void handleProcessingError(Throwable t) {
        String msg = this.isInternalException(t) ? MessageFormat.format("An internal error occurred during the target product processing.\n{0}", this.formatThrowable(t)) : MessageFormat.format("A problem occurred during processing the target product processing.\n{0}", this.formatThrowable(t));
        this.appContext.handleError(msg, t);
    }

    private boolean isInternalException(Throwable t) {
        return t instanceof RuntimeException && !(t instanceof OperatorException) || t instanceof Error;
    }

    private String formatThrowable(Throwable t) {
        return MessageFormat.format("Type: {0}\nMessage: {1}\n", t.getClass().getSimpleName(), t.getMessage());
    }

    protected boolean canApply() {
        File productFile;
        int answer;
        String message;
        Product existingProduct;
        String productName = this.targetProductSelector.getModel().getProductName();
        if (productName == null || productName.isEmpty()) {
            this.showErrorDialog("Please specify a target product name.");
            this.targetProductSelector.getProductNameTextField().requestFocus();
            return false;
        }
        if (this.targetProductSelector.getModel().isOpenInAppSelected() && (existingProduct = this.appContext.getProductManager().getProduct(productName)) != null) {
            message = MessageFormat.format("A product with the name ''{0}'' is already opened in {1}.\n\nDo you want to continue?", productName, this.appContext.getApplicationName());
            answer = JOptionPane.showConfirmDialog(this.getJDialog(), message, this.getTitle(), 0);
            if (answer != 0) {
                return false;
            }
        }
        if (this.targetProductSelector.getModel().isSaveToFileSelected() && (productFile = this.targetProductSelector.getModel().getProductFile()).exists()) {
            message = MessageFormat.format("The specified output file\n\"{0}\"\n already exists.\n\nDo you want to overwrite the existing file?", productFile.getPath());
            answer = JOptionPane.showConfirmDialog(this.getJDialog(), message, this.getTitle(), 0);
            if (answer != 0) {
                return false;
            }
        }
        return true;
    }

    private void showSaveInfo(long saveTime) {
        File productFile = this.getTargetProductSelector().getModel().getProductFile();
        String message = MessageFormat.format("The target product has been successfully written to\n{0}\nTotal time spend for processing: {1}", this.formatFile(productFile), this.formatDuration(saveTime));
        this.showSuppressibleInformationDialog(message, "saveInfo");
    }

    protected void showOpenInAppInfo() {
        String message = MessageFormat.format("The target product has successfully been created and opened in {0}.\n\nActual processing of source to target data will be performed only on demand,\nfor example, if the target product is saved or an image view is opened.", this.appContext.getApplicationName());
        this.showSuppressibleInformationDialog(message, "openInAppInfo");
    }

    private void showSaveAndOpenInAppInfo(long saveTime) {
        File productFile = this.getTargetProductSelector().getModel().getProductFile();
        String message = MessageFormat.format("The target product has been successfully written to\n{0}\nand has been opened in {1}.\nTotal time spend for processing: {2}\n", this.formatFile(productFile), this.appContext.getApplicationName(), this.formatDuration(saveTime));
        this.showSuppressibleInformationDialog(message, "saveAndOpenInAppInfo");
    }

    String formatFile(File file) {
        return FileUtils.getDisplayText((File)file, (int)54);
    }

    String formatDuration(long millis) {
        long seconds = millis / 1000L;
        millis -= seconds * 1000L;
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        return String.format("%02d:%02d:%02d.%03d", hours, minutes -= hours * 60L, seconds, millis);
    }

    public void showSuppressibleInformationDialog(String infoMessage, String propertyName) {
        SuppressibleOptionPane optionPane = new SuppressibleOptionPane(this.appContext.getPreferences());
        optionPane.showMessageDialog(((Object)((Object)this)).getClass().getName() + "." + propertyName, (Component)this.getJDialog(), (Object)infoMessage, this.getTitle(), 1);
    }

    protected abstract Product createTargetProduct() throws Exception;

    private class ProductWriterSwingWorker
    extends ProgressMonitorSwingWorker<Product, Object> {
        private final Product targetProduct;
        private long saveTime;

        private ProductWriterSwingWorker(Product targetProduct) {
            super((Component)SingleTargetProductDialog.this.getJDialog(), "Writing Target Product");
            this.targetProduct = targetProduct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Product doInBackground(ProgressMonitor pm) throws Exception {
            TargetProductSelectorModel model = SingleTargetProductDialog.this.getTargetProductSelector().getModel();
            pm.beginTask("Writing...", model.isOpenInAppSelected() ? 100 : 95);
            this.saveTime = 0L;
            Product product = null;
            try {
                long t0 = System.currentTimeMillis();
                Operator execOp = null;
                if (this.targetProduct.getProductReader() instanceof OperatorProductReader) {
                    boolean autoWriteDisabled;
                    OperatorProductReader opReader = (OperatorProductReader)this.targetProduct.getProductReader();
                    Operator operator = opReader.getOperatorContext().getOperator();
                    boolean bl = autoWriteDisabled = operator instanceof Output || operator.getSpi().getOperatorDescriptor().isAutoWriteDisabled();
                    if (autoWriteDisabled) {
                        execOp = operator;
                    }
                }
                if (execOp == null) {
                    WriteOp writeOp = new WriteOp(this.targetProduct, model.getProductFile(), model.getFormatName());
                    writeOp.setDeleteOutputOnFailure(true);
                    writeOp.setWriteEntireTileRows(true);
                    writeOp.setClearCacheAfterRowWrite(false);
                    execOp = writeOp;
                }
                OperatorExecutor executor = OperatorExecutor.create(execOp);
                executor.execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)95));
                this.saveTime = System.currentTimeMillis() - t0;
                if (model.isOpenInAppSelected()) {
                    File targetFile = model.getProductFile();
                    if (!targetFile.exists()) {
                        targetFile = this.targetProduct.getFileLocation();
                    }
                    if (targetFile.exists()) {
                        product = ProductIO.readProduct((File)targetFile);
                        if (product == null) {
                            product = this.targetProduct;
                        }
                        pm.worked(5);
                    }
                }
            }
            finally {
                pm.done();
                if (product != this.targetProduct) {
                    this.targetProduct.dispose();
                }
            }
            return product;
        }

        protected void done() {
            TargetProductSelectorModel model = SingleTargetProductDialog.this.getTargetProductSelector().getModel();
            try {
                Product targetProduct = (Product)this.get();
                if (model.isOpenInAppSelected()) {
                    SingleTargetProductDialog.this.appContext.getProductManager().addProduct(targetProduct);
                    SingleTargetProductDialog.this.showSaveAndOpenInAppInfo(this.saveTime);
                } else {
                    SingleTargetProductDialog.this.showSaveInfo(this.saveTime);
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                SingleTargetProductDialog.this.handleProcessingError(e.getCause());
            }
            catch (Throwable t) {
                SingleTargetProductDialog.this.handleProcessingError(t);
            }
        }
    }
}

