/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="Read", category="Input-Output", version="1.1", authors="Marco Zuehlke, Norman Fomferra", copyright="(c) 2010 by Brockmann Consult", description="Reads a product from disk.")
public class ReadOp
extends Operator {
    @Parameter(description="The file from which the data product is read.", notNull=true, notEmpty=true)
    private File file;
    @TargetProduct
    private Product targetProduct;
    private transient ProductReader productReader;

    @Override
    public void initialize() throws OperatorException {
        try {
            this.targetProduct = ProductIO.readProduct((File)this.file);
            this.productReader = this.targetProduct.getProductReader();
            this.targetProduct.setFileLocation(this.file);
            this.updateMetadata();
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    private void updateMetadata() {
        MetadataElement inputElem;
        MetadataElement root = this.targetProduct.getMetadataRoot();
        if (root == null) {
            return;
        }
        MetadataElement abstractedMetadata = root.getElement("Abstracted_Metadata");
        if (abstractedMetadata == null) {
            return;
        }
        MetadataElement productElem = abstractedMetadata.getElement("Product_Information");
        if (productElem == null) {
            productElem = new MetadataElement("Product_Information");
            abstractedMetadata.addElement(productElem);
        }
        if ((inputElem = productElem.getElement("InputProducts")) == null) {
            inputElem = new MetadataElement("InputProducts");
            productElem.addElement(inputElem);
        }
        MetadataAttribute[] inputProductAttrbList = inputElem.getAttributes();
        boolean found = false;
        for (MetadataAttribute attrib : inputProductAttrbList) {
            if (!attrib.getData().getElemString().equals(this.targetProduct.getName())) continue;
            found = true;
        }
        if (!found) {
            MetadataAttribute inputAttrb = ReadOp.addAttribute(inputElem, "InputProduct", 41, "", "");
            inputAttrb.getData().setElems((Object)this.targetProduct.getName());
        }
    }

    public static MetadataAttribute addAttribute(MetadataElement dest, String tag, int dataType, String unit, String desc) {
        MetadataAttribute attribute = new MetadataAttribute(tag, dataType, 1);
        attribute.setUnit(unit);
        attribute.setDescription(desc);
        attribute.setReadOnly(true);
        dest.addAttribute(attribute);
        return attribute;
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData dataBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.productReader.readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, dataBuffer, pm);
            targetTile.setRawSamples(dataBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ReadOp.class);
        }
    }
}

