/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.ndvi;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;

@OperatorMetadata(alias="NdviOp", category="Optical Processing/Thematic Land Processing", description="The retrieves the Normalized Difference Vegetation Index (NDVI).", authors="Maximilian Aulinger, Thomas Storm", copyright="Copyright (C) 2002-2014 by Brockmann Consult (info@brockmann-consult.de)")
public class NdviOp
extends Operator {
    public static final String NDVI_BAND_NAME = "ndvi";
    public static final String NDVI_FLAGS_BAND_NAME = "ndvi_flags";
    public static final String NDVI_ARITHMETIC_FLAG_NAME = "NDVI_ARITHMETIC";
    public static final String NDVI_LOW_FLAG_NAME = "NDVI_NEGATIVE";
    public static final String NDVI_HIGH_FLAG_NAME = "NDVI_SATURATION";
    public static final int NDVI_ARITHMETIC_FLAG_VALUE = 1;
    public static final int NDVI_LOW_FLAG_VALUE = 2;
    public static final int NDVI_HIGH_FLAG_VALUE = 4;
    @SourceProduct(alias="source", description="The source product.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(label="Red factor", defaultValue="1.0F", description="The value of the red source band is multiplied by this value.")
    private float redFactor;
    @Parameter(label="NIR factor", defaultValue="1.0F", description="The value of the NIR source band is multiplied by this value.")
    private float nirFactor;
    @Parameter(label="Red source band", description="The red band for the NDVI computation. If not provided, the operator will try to find the best fitting band.", rasterDataNodeType=Band.class)
    private String redSourceBand;
    @Parameter(label="NIR source band", description="The near-infrared band for the NDVI computation. If not provided, the operator will try to find the best fitting band.", rasterDataNodeType=Band.class)
    private String nirSourceBand;

    public void initialize() throws OperatorException {
        this.loadSourceBands(this.sourceProduct);
        int sceneWidth = this.sourceProduct.getSceneRasterWidth();
        int sceneHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(NDVI_BAND_NAME, this.sourceProduct.getProductType() + "_NDVI", sceneWidth, sceneHeight);
        Band ndviOutputBand = new Band(NDVI_BAND_NAME, 30, sceneWidth, sceneHeight);
        this.targetProduct.addBand(ndviOutputBand);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        FlagCoding ndviFlagCoding = NdviOp.createNdviFlagCoding();
        this.targetProduct.getFlagCodingGroup().add((ProductNode)ndviFlagCoding);
        Band ndviFlagsOutputBand = new Band(NDVI_FLAGS_BAND_NAME, 12, sceneWidth, sceneHeight);
        ndviFlagsOutputBand.setDescription("NDVI specific flags");
        ndviFlagsOutputBand.setSampleCoding((SampleCoding)ndviFlagCoding);
        this.targetProduct.addBand(ndviFlagsOutputBand);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyOverlayMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.addMask(NDVI_ARITHMETIC_FLAG_NAME, "ndvi_flags.NDVI_ARITHMETIC", "An arithmetic exception occurred.", Color.red.brighter(), 0.7);
        this.targetProduct.addMask(NDVI_LOW_FLAG_NAME, "ndvi_flags.NDVI_NEGATIVE", "NDVI value is too low.", Color.red, 0.7);
        this.targetProduct.addMask(NDVI_HIGH_FLAG_NAME, "ndvi_flags.NDVI_SATURATION", "NDVI value is too high.", Color.red.darker(), 0.7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        pm.beginTask("Computing NDVI", rectangle.height);
        try {
            Tile redTile = this.getSourceTile((RasterDataNode)this.getSourceProduct().getBand(this.redSourceBand), rectangle);
            Tile nirTile = this.getSourceTile((RasterDataNode)this.getSourceProduct().getBand(this.nirSourceBand), rectangle);
            Tile ndvi = targetTiles.get(this.targetProduct.getBand(NDVI_BAND_NAME));
            Tile ndviFlags = targetTiles.get(this.targetProduct.getBand(NDVI_FLAGS_BAND_NAME));
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    float nir = this.nirFactor * nirTile.getSampleFloat(x, y);
                    float red = this.redFactor * redTile.getSampleFloat(x, y);
                    float ndviValue = (nir - red) / (nir + red);
                    int ndviFlagsValue = 0;
                    if (Float.isNaN(ndviValue) || Float.isInfinite(ndviValue)) {
                        ndviFlagsValue |= 1;
                        ndviValue = 0.0f;
                    }
                    if (ndviValue < 0.0f) {
                        ndviFlagsValue |= 2;
                    }
                    if (ndviValue > 1.0f) {
                        ndviFlagsValue |= 4;
                    }
                    ndvi.setSample(x, y, ndviValue);
                    ndviFlags.setSample(x, y, ndviFlagsValue);
                }
                this.checkForCancellation();
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private void loadSourceBands(Product product) throws OperatorException {
        if (this.redSourceBand == null) {
            this.redSourceBand = NdviOp.findBand(600.0f, 650.0f, product);
            this.getLogger().info("Using band '" + this.redSourceBand + "' as red input band.");
        }
        if (this.nirSourceBand == null) {
            this.nirSourceBand = NdviOp.findBand(800.0f, 900.0f, product);
            this.getLogger().info("Using band '" + this.nirSourceBand + "' as NIR input band.");
        }
        if (this.redSourceBand == null) {
            throw new OperatorException("Unable to find band that could be used as red input band. Please specify band.");
        }
        if (this.nirSourceBand == null) {
            throw new OperatorException("Unable to find band that could be used as nir input band. Please specify band.");
        }
    }

    static String findBand(float minWavelength, float maxWavelength, Product product) {
        String bestBand = null;
        float bestBandLowerDelta = Float.MAX_VALUE;
        for (Band band : product.getBands()) {
            float lowerDelta;
            float bandWavelength = band.getSpectralWavelength();
            if (bandWavelength == 0.0f || !((lowerDelta = bandWavelength - minWavelength) < bestBandLowerDelta) || !(bandWavelength <= maxWavelength) || !(bandWavelength >= minWavelength)) continue;
            bestBand = band.getName();
            bestBandLowerDelta = lowerDelta;
        }
        return bestBand;
    }

    private static FlagCoding createNdviFlagCoding() {
        FlagCoding ndviFlagCoding = new FlagCoding(NDVI_FLAGS_BAND_NAME);
        ndviFlagCoding.setDescription("NDVI Flag Coding");
        MetadataAttribute attribute = new MetadataAttribute(NDVI_ARITHMETIC_FLAG_NAME, 12);
        attribute.getData().setElemInt(1);
        attribute.setDescription("NDVI value calculation failed due to an arithmetic exception");
        ndviFlagCoding.addAttribute(attribute);
        attribute = new MetadataAttribute(NDVI_LOW_FLAG_NAME, 12);
        attribute.getData().setElemInt(2);
        attribute.setDescription("NDVI value is too low");
        ndviFlagCoding.addAttribute(attribute);
        attribute = new MetadataAttribute(NDVI_HIGH_FLAG_NAME, 12);
        attribute.getData().setElemInt(4);
        attribute.setDescription("NDVI value is too high");
        ndviFlagCoding.addAttribute(attribute);
        return ndviFlagCoding;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(NdviOp.class);
        }
    }
}

