/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.beam.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.beam.dataio.netcdf.NetCdfReadProfile;
import org.esa.beam.dataio.netcdf.ProfileReadContextImpl;
import org.esa.beam.dataio.netcdf.util.NetcdfFileOpener;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.io.FileUtils;
import ucar.nc2.NetcdfFile;

class DefaultNetCdfReader
extends AbstractProductReader {
    private NetcdfFile netcdfFile;

    public DefaultNetCdfReader(AbstractNetCdfReaderPlugIn netCdfReaderPlugIn) {
        super((ProductReaderPlugIn)netCdfReaderPlugIn);
    }

    public AbstractNetCdfReaderPlugIn getReaderPlugIn() {
        return (AbstractNetCdfReaderPlugIn)super.getReaderPlugIn();
    }

    protected Product readProductNodesImpl() throws IOException {
        AbstractNetCdfReaderPlugIn plugIn = this.getReaderPlugIn();
        File fileLocation = new File(this.getInput().toString());
        this.netcdfFile = NetcdfFileOpener.open(fileLocation.getPath());
        if (this.netcdfFile == null) {
            throw new IOException("Failed to open file " + fileLocation.getPath());
        }
        ProfileReadContextImpl context = new ProfileReadContextImpl(this.netcdfFile);
        String filename = DefaultNetCdfReader.extractProductName(fileLocation);
        context.setProperty("productName", filename);
        plugIn.initReadContext(context);
        NetCdfReadProfile profile = new NetCdfReadProfile();
        this.configureProfile(plugIn, profile);
        Product product = profile.readProduct(context);
        product.setFileLocation(fileLocation);
        product.setProductReader((ProductReader)this);
        product.setModified(false);
        return product;
    }

    static String extractProductName(File fileLocation) {
        String name = fileLocation.getName();
        if (name.endsWith(".gz") || name.endsWith(".zip")) {
            int dotIndex = name.lastIndexOf(".");
            name = name.substring(0, dotIndex);
        }
        return FileUtils.getFilenameWithoutExtension((String)name);
    }

    private void configureProfile(AbstractNetCdfReaderPlugIn plugIn, NetCdfReadProfile profile) {
        profile.setInitialisationPartReader(plugIn.createInitialisationPartReader());
        profile.addProfilePartReader(plugIn.createMetadataPartReader());
        profile.addProfilePartReader(plugIn.createBandPartReader());
        profile.addProfilePartReader(plugIn.createTiePointGridPartReader());
        profile.addProfilePartReader(plugIn.createFlagCodingPartReader());
        profile.addProfilePartReader(plugIn.createGeoCodingPartReader());
        profile.addProfilePartReader(plugIn.createImageInfoPartReader());
        profile.addProfilePartReader(plugIn.createIndexCodingPartReader());
        profile.addProfilePartReader(plugIn.createMaskPartReader());
        profile.addProfilePartReader(plugIn.createStxPartReader());
        profile.addProfilePartReader(plugIn.createTimePartReader());
        profile.addProfilePartReader(plugIn.createDescriptionPartReader());
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("Data is provided by images");
    }

    public void close() throws IOException {
        if (this.netcdfFile != null) {
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
        super.close();
    }
}

