/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.beam.framework.datamodel.Product;

class NetCdfWriteProfile {
    private ProfileInitPartWriter profileInitPart;
    private final List<ProfilePartWriter> profileParts = new ArrayList<ProfilePartWriter>();

    NetCdfWriteProfile() {
    }

    public void setInitialisationPartWriter(ProfileInitPartWriter initPart) {
        this.profileInitPart = initPart;
    }

    public void addProfilePartWriter(ProfilePartWriter profilePart) {
        this.profileParts.add(profilePart);
    }

    public void writeProduct(ProfileWriteContext ctx, Product product) throws IOException {
        this.profileInitPart.writeProductBody(ctx, product);
        for (ProfilePartWriter profilePart : this.profileParts) {
            profilePart.preEncode(ctx, product);
        }
        ctx.getNetcdfFileWriteable().create();
        for (ProfilePartWriter profilePart : this.profileParts) {
            profilePart.encode(ctx, product);
        }
    }
}

