/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import java.awt.Color;
import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamImageInfoPart
extends ProfilePartIO {
    public static final String COLOR_TABLE_SAMPLE_VALUES = "color_table_sample_values";
    public static final String COLOR_TABLE_RED_VALUES = "color_table_red_values";
    public static final String COLOR_TABLE_GREEN_VALUES = "color_table_green_values";
    public static final String COLOR_TABLE_BLUE_VALUES = "color_table_blue_values";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        for (Band band : p.getBands()) {
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Variable variable = netcdfFile.getRootGroup().findVariable(variableName);
            BeamImageInfoPart.readImageInfo(variable, band);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        NFileWriteable fileWriteable = ctx.getNetcdfFileWriteable();
        for (Band band : p.getBands()) {
            String variableName;
            NVariable variable;
            ImageInfo imageInfo = band.getImageInfo();
            if (imageInfo == null || (variable = fileWriteable.findVariable(variableName = ReaderUtils.getVariableName((RasterDataNode)band))) == null) continue;
            BeamImageInfoPart.writeImageInfo(imageInfo.getColorPaletteDef().getPoints(), variable);
        }
    }

    private static void writeImageInfo(ColorPaletteDef.Point[] points, NVariable variable) throws IOException {
        double[] sampleValues = new double[points.length];
        int[] redValues = new int[points.length];
        int[] greenValues = new int[points.length];
        int[] blueValues = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            ColorPaletteDef.Point point = points[i];
            sampleValues[i] = point.getSample();
            redValues[i] = point.getColor().getRed();
            greenValues[i] = point.getColor().getGreen();
            blueValues[i] = point.getColor().getBlue();
        }
        variable.addAttribute(COLOR_TABLE_SAMPLE_VALUES, Array.factory((Object)sampleValues));
        variable.addAttribute(COLOR_TABLE_RED_VALUES, Array.factory((Object)redValues));
        variable.addAttribute(COLOR_TABLE_GREEN_VALUES, Array.factory((Object)greenValues));
        variable.addAttribute(COLOR_TABLE_BLUE_VALUES, Array.factory((Object)blueValues));
    }

    private static void readImageInfo(Variable variable, Band band) throws ProductIOException {
        Attribute sampleValues = variable.findAttributeIgnoreCase(COLOR_TABLE_SAMPLE_VALUES);
        Attribute redValues = variable.findAttributeIgnoreCase(COLOR_TABLE_RED_VALUES);
        Attribute greenValues = variable.findAttributeIgnoreCase(COLOR_TABLE_GREEN_VALUES);
        Attribute blueValues = variable.findAttributeIgnoreCase(COLOR_TABLE_BLUE_VALUES);
        Attribute[] attributes = new Attribute[]{sampleValues, redValues, greenValues, blueValues};
        if (BeamImageInfoPart.allAttributesAreNotNullAndHaveTheSameSize(attributes)) {
            ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[sampleValues.getLength()];
            for (int i = 0; i < points.length; ++i) {
                int red = redValues.getNumericValue(i).intValue();
                int green = greenValues.getNumericValue(i).intValue();
                int blue = blueValues.getNumericValue(i).intValue();
                Color color = new Color(red, green, blue);
                points[i] = new ColorPaletteDef.Point(sampleValues.getNumericValue(i).doubleValue(), color);
            }
            band.setImageInfo(new ImageInfo(new ColorPaletteDef(points)));
        }
    }

    static boolean allElementsAreNotNull(Object[] array) {
        if (array != null) {
            for (Object o : array) {
                if (o != null) continue;
                return false;
            }
        }
        return true;
    }

    static boolean allAttributesAreNotNullAndHaveTheSameSize(Attribute[] attributes) {
        if (BeamImageInfoPart.allElementsAreNotNull(attributes)) {
            Attribute prim = attributes[0];
            for (int i = 1; i < attributes.length; ++i) {
                if (prim.getLength() == attributes[i].getLength()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

