/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfIndexCodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class BeamIndexCodingPart
extends ProfilePartIO {
    public static final String INDEX_DESCRIPTIONS = "index_descriptions";
    public static final String DESCRIPTION_SEPARATOR = "\t";
    public static final String INDEX_CODING_NAME = "index_coding_name";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        Band[] bands;
        for (Band band : bands = p.getBands()) {
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Variable variable = ctx.getNetcdfFile().getRootGroup().findVariable(variableName);
            IndexCoding indexCoding = BeamIndexCodingPart.readIndexCoding(variable, band.getName() + "_index_coding");
            if (indexCoding == null) continue;
            p.getIndexCodingGroup().add((ProductNode)indexCoding);
            band.setSampleCoding((SampleCoding)indexCoding);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        for (Band band : p.getBands()) {
            IndexCoding indexCoding = band.getIndexCoding();
            if (indexCoding == null) continue;
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            NVariable variable = writeable.findVariable(variableName);
            this.writeIndexCoding(indexCoding, variable);
        }
    }

    private void writeIndexCoding(IndexCoding indexCoding, NVariable variable) throws IOException {
        CfIndexCodingPart.writeIndexCoding(indexCoding, variable);
        String[] indexNames = indexCoding.getIndexNames();
        StringBuilder descriptions = new StringBuilder();
        for (String indexName : indexNames) {
            String description;
            MetadataAttribute index = indexCoding.getIndex(indexName);
            if (index != null && (description = index.getDescription()) != null) {
                descriptions.append(description);
            }
            descriptions.append(DESCRIPTION_SEPARATOR);
        }
        variable.addAttribute(INDEX_DESCRIPTIONS, descriptions.toString().trim());
        variable.addAttribute(INDEX_CODING_NAME, indexCoding.getName());
    }

    private static IndexCoding readIndexCoding(Variable variable, String indexCodingName) throws ProductIOException {
        IndexCoding indexCoding = CfIndexCodingPart.readIndexCoding(variable, indexCodingName);
        if (indexCoding != null) {
            Attribute nameAtt;
            Attribute descriptionsAtt = variable.findAttributeIgnoreCase(INDEX_DESCRIPTIONS);
            if (descriptionsAtt != null) {
                String[] descriptions = descriptionsAtt.getStringValue().split(DESCRIPTION_SEPARATOR);
                if (indexCoding.getNumAttributes() == descriptions.length) {
                    for (int i = 0; i < descriptions.length; ++i) {
                        indexCoding.getAttributeAt(i).setDescription(descriptions[i]);
                    }
                }
            }
            if ((nameAtt = variable.findAttributeIgnoreCase(INDEX_CODING_NAME)) != null) {
                indexCoding.setName(nameAtt.getStringValue());
            }
        }
        return indexCoding;
    }
}

