/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.dataio.netcdf.util.MetadataUtils;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamMetadataPart
extends ProfilePartIO {
    private static final String SPLITTER = ":";
    private static final String METADATA_VARIABLE = "metadata";
    private static final String DESCRIPTION_SUFFIX = "descr";
    private static final String UNIT_SUFFIX = "unit";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        Variable metadata = netcdfFile.getRootGroup().findVariable(METADATA_VARIABLE);
        MetadataElement metadataRoot = p.getMetadataRoot();
        MetadataUtils.readNetcdfMetadata(netcdfFile, p.getMetadataRoot());
        if (metadata != null) {
            for (Attribute attribute : metadata.getAttributes()) {
                String attrName = attribute.getShortName();
                if (attrName.startsWith(SPLITTER)) {
                    attrName = attrName.substring(1, attrName.length());
                }
                if (attrName.contains(SPLITTER)) {
                    String prefix = attrName.split(SPLITTER)[0];
                    this.readMetadata(attribute, metadataRoot, prefix);
                    continue;
                }
                ProductData attributeValue = DataTypeUtils.createProductData(attribute);
                metadataRoot.addAttribute(new MetadataAttribute(attrName, attributeValue, true));
            }
        }
    }

    private void readMetadata(Attribute attribute, MetadataElement metadataRoot, String prefix) {
        String temp;
        MetadataElement metadataElement;
        String[] splittedPrefix = prefix.split(SPLITTER);
        String metaDataElementName = prefix;
        if (splittedPrefix.length > 1) {
            metaDataElementName = splittedPrefix[splittedPrefix.length - 1];
        }
        if ((metadataElement = metadataRoot.getElement(metaDataElementName)) == null) {
            metadataElement = new MetadataElement(metaDataElementName);
            metadataRoot.addElement(metadataElement);
        }
        if ((temp = attribute.getShortName()).startsWith(SPLITTER)) {
            temp = temp.substring(1, temp.length());
        }
        if ((temp = temp.replaceFirst(prefix, "")).startsWith(SPLITTER)) {
            temp = temp.substring(1, temp.length());
        }
        String[] splittedAttrName = temp.split(SPLITTER);
        temp = splittedAttrName[0];
        if (splittedAttrName.length > 1) {
            this.readMetadata(attribute, metadataElement, prefix + SPLITTER + temp);
        } else {
            String newAttributeName = attribute.getShortName().replaceFirst(prefix, "").replace(SPLITTER, "");
            if (newAttributeName.endsWith(".unit")) {
                newAttributeName = newAttributeName.substring(0, newAttributeName.length() - UNIT_SUFFIX.length() - 1);
                MetadataAttribute anAttribute = metadataElement.getAttribute(newAttributeName);
                String value = attribute.getStringValue();
                if (value != null) {
                    anAttribute.setUnit(value);
                }
            } else if (newAttributeName.endsWith(".descr")) {
                newAttributeName = newAttributeName.substring(0, newAttributeName.length() - DESCRIPTION_SUFFIX.length() - 1);
                MetadataAttribute anAttribute = metadataElement.getAttribute(newAttributeName);
                String value = attribute.getStringValue();
                if (value != null) {
                    anAttribute.setDescription(value);
                }
            } else {
                ProductData attributeValue = DataTypeUtils.createProductData(attribute);
                MetadataAttribute newAttribute = new MetadataAttribute(newAttributeName, attributeValue, true);
                metadataElement.addAttribute(newAttribute);
            }
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        MetadataElement root = p.getMetadataRoot();
        if (root != null) {
            NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
            NVariable variable = ncFile.addScalarVariable(METADATA_VARIABLE, DataType.BYTE);
            this.writeMetadataElement(ncFile, root, variable, "");
        }
    }

    private void writeMetadataElement(NFileWriteable ncFile, MetadataElement element, NVariable ncVariable, String prefix) throws IOException {
        int i;
        for (i = 0; i < element.getNumAttributes(); ++i) {
            MetadataAttribute attribute = element.getAttributeAt(i);
            this.writeMetadataAttribute(ncFile, attribute, ncVariable, prefix);
        }
        for (i = 0; i < element.getNumElements(); ++i) {
            MetadataElement subElement = element.getElementAt(i);
            String subElementName = subElement.getName();
            if (this.isGlobalAttributesElement(subElementName)) continue;
            String name = prefix.isEmpty() ? subElementName : prefix + SPLITTER + subElementName;
            this.writeMetadataElement(ncFile, subElement, ncVariable, name);
        }
    }

    private boolean isGlobalAttributesElement(String subElementName) {
        return "Global_Attributes".equals(subElementName) || "Variable_Attributes".equals(subElementName);
    }

    private void writeMetadataAttribute(NFileWriteable ncFile, MetadataAttribute metadataAttr, NVariable ncVariable, String prefix) throws IOException {
        ProductData productData = metadataAttr.getData();
        String ncAttributeName = prefix.isEmpty() ? metadataAttr.getName() : prefix + SPLITTER + metadataAttr.getName();
        if (!ncFile.isNameValid(ncAttributeName)) {
            ncAttributeName = ncFile.makeNameValid(ncAttributeName);
        }
        if (productData instanceof ProductData.ASCII || productData instanceof ProductData.UTC) {
            ncVariable.addAttribute(ncAttributeName, productData.getElemString());
        } else {
            ncVariable.addAttribute(ncAttributeName, Array.factory((Object)productData.getElems()));
        }
        if (metadataAttr.getUnit() != null) {
            ncVariable.addAttribute(ncAttributeName + "." + UNIT_SUFFIX, metadataAttr.getUnit());
        }
        if (metadataAttr.getDescription() != null) {
            ncVariable.addAttribute(ncAttributeName + "." + DESCRIPTION_SUFFIX, metadataAttr.getDescription());
        }
    }
}

