/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.StxFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class BeamStxPart
extends ProfilePartIO {
    public final String STATISTICS = "statistics";
    public final String SAMPLE_FREQUENCIES = "sample_frequencies";
    public final int INDEX_SCALED_MIN = 0;
    public final int INDEX_SCALED_MAX = 1;
    public final int INDEX_MEAN = 2;
    public final int INDEX_STANDARD_DEVIATION = 3;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        for (Band band : p.getBands()) {
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Variable variable = ctx.getNetcdfFile().getRootGroup().findVariable(variableName);
            Attribute statistics = variable.findAttributeIgnoreCase("statistics");
            Attribute sampleFrequencies = variable.findAttributeIgnoreCase("sample_frequencies");
            if (statistics == null || sampleFrequencies == null || statistics.getLength() < 2) continue;
            double min = statistics.getNumericValue(0).doubleValue();
            double max = statistics.getNumericValue(1).doubleValue();
            Number meanNumber = statistics.getNumericValue(2);
            double mean = meanNumber != null ? meanNumber.doubleValue() : Double.NaN;
            Number stdDevNumber = statistics.getNumericValue(3);
            double stdDev = stdDevNumber != null ? stdDevNumber.doubleValue() : Double.NaN;
            boolean intHistogram = !ProductData.isFloatingPointType((int)band.getGeophysicalDataType());
            int[] frequencies = new int[sampleFrequencies.getLength()];
            for (int i = 0; i < frequencies.length; ++i) {
                Number fNumber = sampleFrequencies.getNumericValue(i);
                frequencies[i] = fNumber != null ? fNumber.intValue() : 0;
            }
            boolean resolutionLevel = false;
            Stx stx = new StxFactory().withMinimum((Number)min).withMaximum((Number)max).withMean((Number)mean).withStandardDeviation((Number)stdDev).withIntHistogram(intHistogram).withHistogramBins(frequencies).withResolutionLevel(Integer.valueOf(0)).create();
            band.setStx(stx);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        for (Band band : p.getBands()) {
            if (!band.isStxSet()) continue;
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            Stx stx = band.getStx();
            NVariable variable = ctx.getNetcdfFileWriteable().findVariable(variableName);
            if (variable == null) continue;
            double[] statistics = new double[]{stx.getMinimum(), stx.getMaximum(), stx.getMean(), stx.getStandardDeviation()};
            variable.addAttribute("statistics", Array.factory((Object)statistics));
            variable.addAttribute("sample_frequencies", Array.factory((Object)stx.getHistogramBins()));
        }
    }
}

