/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.cf;

import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfHdfEosGeoInfoExtractor;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGeocodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.dataio.netcdf.nc.NVariable;
import org.esa.beam.dataio.netcdf.util.DimKey;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoCodingFactory;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.logging.BeamLogManager;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class CfGeocodingPart
extends ProfilePartIO {
    private boolean geographicCRS;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        GeoCoding geoCoding = CfGeocodingPart.readConventionBasedMapGeoCoding(ctx, p);
        if (geoCoding == null) {
            geoCoding = CfGeocodingPart.readPixelGeoCoding(p);
        }
        if (geoCoding == null && this.hasHdfMetadataOrigin(ctx.getNetcdfFile().getGlobalAttributes())) {
            this.hdfDecode(ctx, p);
        }
        if (geoCoding != null) {
            p.setGeoCoding(geoCoding);
        }
    }

    private void hdfDecode(ProfileReadContext ctx, Product p) throws IOException {
        CfHdfEosGeoInfoExtractor cfHdfEosGeoInfoExtractor = new CfHdfEosGeoInfoExtractor(ctx.getNetcdfFile().getGlobalAttributes());
        cfHdfEosGeoInfoExtractor.extractInfo();
        String projection = cfHdfEosGeoInfoExtractor.getProjection();
        double upperLeftLon = cfHdfEosGeoInfoExtractor.getUlLon();
        double upperLeftLat = cfHdfEosGeoInfoExtractor.getUlLat();
        double lowerRightLon = cfHdfEosGeoInfoExtractor.getLrLon();
        double lowerRightLat = cfHdfEosGeoInfoExtractor.getLrLat();
        HdfEosGeocodingPart.attachGeoCoding(p, upperLeftLon, upperLeftLat, lowerRightLon, lowerRightLat, projection, null);
    }

    private boolean hasHdfMetadataOrigin(List<Attribute> netcdfAttributes) {
        for (Attribute att : netcdfAttributes) {
            if (!att.getShortName().startsWith("StructMetadata")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product product) throws IOException {
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding == null) {
            return;
        }
        this.geographicCRS = CfGeocodingPart.isGeographicCRS(geoCoding);
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        boolean latLonPresent = this.isLatLonPresent(ncFile);
        if (!latLonPresent) {
            if (this.geographicCRS) {
                GeoPos ul = geoCoding.getGeoPos(new PixelPos(0.5f, 0.5f), null);
                int w = product.getSceneRasterWidth();
                int h = product.getSceneRasterHeight();
                GeoPos br = geoCoding.getGeoPos(new PixelPos((float)w - 0.5f, (float)h - 0.5f), null);
                this.addGeographicCoordinateVariables(ncFile, ul, br);
            } else {
                this.addLatLonBands(ncFile, ImageManager.getPreferredTileSize((Product)product));
            }
        }
        ctx.setProperty("yFlipped", false);
    }

    private boolean isLatLonPresent(NFileWriteable ncFile) {
        return ncFile.findVariable("lat") != null && ncFile.findVariable("lon") != null;
    }

    @Override
    public void encode(ProfileWriteContext ctx, Product product) throws IOException {
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        if (!this.isLatLonPresent(ncFile)) {
            return;
        }
        int h = product.getSceneRasterHeight();
        int w = product.getSceneRasterWidth();
        GeoCoding geoCoding = product.getGeoCoding();
        PixelPos pixelPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        NVariable latVariable = ncFile.findVariable("lat");
        NVariable lonVariable = ncFile.findVariable("lon");
        if (this.geographicCRS) {
            float[] lat = new float[h];
            float[] lon = new float[w];
            pixelPos.x = 0.5f;
            for (int y = 0; y < h; ++y) {
                pixelPos.y = (float)y + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                lat[y] = geoPos.getLat();
            }
            pixelPos.y = 0.5f;
            for (int x = 0; x < w; ++x) {
                pixelPos.x = (float)x + 0.5f;
                geoCoding.getGeoPos(pixelPos, geoPos);
                lon[x] = geoPos.getLon();
            }
            latVariable.writeFully(Array.factory((Object)lat));
            lonVariable.writeFully(Array.factory((Object)lon));
        } else {
            float[] lat = new float[w];
            float[] lon = new float[w];
            boolean isYFlipped = (Boolean)ctx.getProperty("yFlipped");
            for (int y = 0; y < h; ++y) {
                pixelPos.y = (float)y + 0.5f;
                for (int x = 0; x < w; ++x) {
                    pixelPos.x = (float)x + 0.5f;
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    lat[x] = geoPos.getLat();
                    lon[x] = geoPos.getLon();
                }
                latVariable.write(0, y, w, 1, isYFlipped, ProductData.createInstance((float[])lat));
                lonVariable.write(0, y, w, 1, isYFlipped, ProductData.createInstance((float[])lon));
            }
        }
    }

    static boolean isGeographicCRS(GeoCoding geoCoding) {
        return (geoCoding instanceof CrsGeoCoding || geoCoding instanceof MapGeoCoding) && CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
    }

    private void addGeographicCoordinateVariables(NFileWriteable ncFile, GeoPos ul, GeoPos br) throws IOException {
        NVariable lat = ncFile.addVariable("lat", DataType.FLOAT, null, "lat");
        lat.addAttribute("units", "degrees_north");
        lat.addAttribute("long_name", "latitude");
        lat.addAttribute("standard_name", "latitude");
        lat.addAttribute("valid_min", Float.valueOf(br.getLat()));
        lat.addAttribute("valid_max", Float.valueOf(ul.getLat()));
        NVariable lon = ncFile.addVariable("lon", DataType.FLOAT, null, "lon");
        lon.addAttribute("units", "degrees_east");
        lon.addAttribute("long_name", "longitude");
        lon.addAttribute("standard_name", "longitude");
        lon.addAttribute("valid_min", Float.valueOf(ul.getLon()));
        lon.addAttribute("valid_max", Float.valueOf(br.getLon()));
    }

    private void addLatLonBands(NFileWriteable ncFile, Dimension tileSize) throws IOException {
        NVariable lat = ncFile.addVariable("lat", DataType.FLOAT, tileSize, "y x");
        lat.addAttribute("units", "degrees_north");
        lat.addAttribute("long_name", "latitude coordinate");
        lat.addAttribute("standard_name", "latitude");
        NVariable lon = ncFile.addVariable("lon", DataType.FLOAT, tileSize, "y x");
        lon.addAttribute("units", "degrees_east");
        lon.addAttribute("long_name", "longitude coordinate");
        lon.addAttribute("standard_name", "longitude");
    }

    private static GeoCoding readConventionBasedMapGeoCoding(ProfileReadContext ctx, Product product) {
        String[] cfConvention_lonLatNames = new String[]{"lon", "lat"};
        String[] coardsConvention_lonLatNames = new String[]{"longitude", "latitude"};
        List variableList = ctx.getNetcdfFile().getVariables();
        Variable[] lonLat = ReaderUtils.getVariables(variableList, cfConvention_lonLatNames);
        if (lonLat == null) {
            lonLat = ReaderUtils.getVariables(variableList, coardsConvention_lonLatNames);
        }
        if (lonLat != null) {
            Variable lonVariable = lonLat[0];
            Variable latVariable = lonLat[1];
            DimKey rasterDim = ctx.getRasterDigest().getRasterDim();
            if (rasterDim.fitsTo(lonVariable, latVariable)) {
                try {
                    return CfGeocodingPart.createConventionBasedMapGeoCoding(lonVariable, latVariable, product.getSceneRasterWidth(), product.getSceneRasterHeight(), ctx);
                }
                catch (Exception e) {
                    BeamLogManager.getSystemLogger().warning("Failed to create NetCDF geo-coding");
                }
            }
        }
        return null;
    }

    private static GeoCoding createConventionBasedMapGeoCoding(Variable lon, Variable lat, int sceneRasterWidth, int sceneRasterHeight, ProfileReadContext ctx) throws Exception {
        double northing;
        boolean yFlipped;
        Array lonData = lon.read();
        if (CfGeocodingPart.isGlobalShifted180(lonData)) {
            List variables = ctx.getNetcdfFile().getVariables();
            for (Variable next : variables) {
                next.getAttributes().add(new Attribute("LONGITUDE_SHIFTED_180", (Number)1));
            }
            int i = 0;
            while ((long)i < lonData.getSize()) {
                Index ii = lonData.getIndex().set(i);
                double theLon = lonData.getDouble(ii) - 180.0;
                lonData.setDouble(ii, theLon);
                ++i;
            }
        }
        Array latData = lat.read();
        int lonSize = lon.getShape(0);
        Index i0 = lonData.getIndex().set(0);
        Index i1 = lonData.getIndex().set(lonSize - 1);
        double pixelSizeX = (lonData.getDouble(i1) - lonData.getDouble(i0)) / (double)(sceneRasterWidth - 1);
        double easting = lonData.getDouble(i0);
        int latSize = lat.getShape(0);
        Index j0 = latData.getIndex().set(0);
        Index j1 = latData.getIndex().set(latSize - 1);
        double pixelSizeY = (latData.getDouble(j1) - latData.getDouble(j0)) / (double)(sceneRasterHeight - 1);
        double pixelX = 0.5;
        double pixelY = 0.5;
        if (pixelSizeY < 0.0) {
            pixelSizeY = -pixelSizeY;
            yFlipped = false;
            northing = latData.getDouble(latData.getIndex().set(0));
        } else {
            yFlipped = true;
            northing = latData.getDouble(latData.getIndex().set(latSize - 1));
        }
        if (pixelSizeX <= 0.0 || pixelSizeY <= 0.0) {
            return null;
        }
        ctx.setProperty("yFlipped", yFlipped);
        return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, sceneRasterWidth, sceneRasterHeight, easting, northing, pixelSizeX, pixelSizeY, pixelX, pixelY);
    }

    static boolean isGlobalShifted180(Array lonData) {
        Index i0 = lonData.getIndex().set(0);
        Index i1 = lonData.getIndex().set(1);
        Index iN = lonData.getIndex().set((int)lonData.getSize() - 1);
        double lonDelta = lonData.getDouble(i1) - lonData.getDouble(i0);
        double firstValue = lonData.getDouble(0);
        double lastValue = lonData.getDouble(iN);
        return firstValue >= 0.0 && firstValue <= lonDelta && lastValue >= 360.0 - lonDelta && lastValue <= 360.0;
    }

    private static GeoCoding readPixelGeoCoding(Product product) throws IOException {
        Band latBand;
        Band lonBand = product.getBand("lon");
        if (lonBand == null) {
            lonBand = product.getBand("longitude");
        }
        if ((latBand = product.getBand("lat")) == null) {
            latBand = product.getBand("latitude");
        }
        if (latBand != null && lonBand != null) {
            return GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)latBand.getValidMaskExpression(), (int)5);
        }
        return null;
    }
}

