/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.cf;

import java.awt.Dimension;
import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfileInitPartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfGeocodingPart;
import org.esa.beam.dataio.netcdf.nc.NFileWriteable;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.jai.ImageManager;
import ucar.nc2.Attribute;

public class CfInitialisationPart
extends ProfileInitPartIO {
    @Override
    public Product readProductBody(ProfileReadContext ctx) throws ProductIOException {
        String[] tileSizes;
        String stringValue;
        Product product = new Product((String)ctx.getProperty("productName"), this.readProductType(ctx), ctx.getRasterDigest().getRasterDim().getDimensionX().getLength(), ctx.getRasterDigest().getRasterDim().getDimensionY().getLength());
        Attribute tileSize = ctx.getNetcdfFile().findGlobalAttribute("TileSize");
        if (tileSize != null && (stringValue = tileSize.getStringValue()) != null && stringValue.contains(":") && (tileSizes = stringValue.split(":")).length == 2) {
            try {
                int tHeight = Integer.parseInt(tileSizes[0]);
                int tWidth = Integer.parseInt(tileSizes[1]);
                product.setPreferredTileSize(tWidth, tHeight);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return product;
    }

    @Override
    public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        writeable.addGlobalAttribute("Conventions", "CF-1.4");
        if (CfGeocodingPart.isGeographicCRS(product.getGeoCoding())) {
            this.writeDimensions(writeable, product, "lat", "lon");
        } else {
            this.writeDimensions(writeable, product, "y", "x");
        }
        Dimension tileSize = ImageManager.getPreferredTileSize((Product)product);
        writeable.addGlobalAttribute("TileSize", tileSize.height + ":" + tileSize.width);
    }

    private void writeDimensions(NFileWriteable writeable, Product p, String dimY, String dimX) throws IOException {
        writeable.addDimension(dimY, p.getSceneRasterHeight());
        writeable.addDimension(dimX, p.getSceneRasterWidth());
    }

    public String readProductType(ProfileReadContext ctx) {
        Attribute productType = ctx.getNetcdfFile().findGlobalAttribute("Conventions");
        if (productType != null) {
            return productType.getStringValue();
        }
        return "NetCDF";
    }
}

