/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.beam.dataio.netcdf.util.ReaderUtils;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;

public class CfTiePointGridPart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        CfBandPart.defineRasterDataNodes(ctx, (RasterDataNode[])p.getTiePointGrids());
    }

    @Override
    public void encode(ProfileWriteContext ctx, Product p) throws IOException {
        boolean doFlip = this.getYFlippedProperty(ctx);
        for (TiePointGrid tiePointGrid : p.getTiePointGrids()) {
            int h = tiePointGrid.getSceneRasterHeight();
            int w = tiePointGrid.getSceneRasterWidth();
            Object data = tiePointGrid.getSourceImage().getData().getDataElements(0, 0, w, h, null);
            ProductData productData = ProductData.createInstance((int)30, (Object)data);
            String variableName = ReaderUtils.getVariableName((RasterDataNode)tiePointGrid);
            ctx.getNetcdfFileWriteable().findVariable(variableName).write(0, 0, w, h, doFlip, productData);
        }
    }

    private boolean getYFlippedProperty(ProfileWriteContext ctx) {
        Object yFlippedProperty = ctx.getProperty("yFlipped");
        if (yFlippedProperty instanceof Boolean) {
            return (Boolean)yFlippedProperty;
        }
        return false;
    }
}

