/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.ScaleDescriptor;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.beam.dataio.netcdf.util.AbstractNetcdfMultiLevelImage;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.dataio.netcdf.util.NetcdfMultiLevelImage;
import org.esa.beam.dataio.netcdf.util.NetcdfOpImage;
import org.esa.beam.dataio.netcdf.util.RasterDigest;
import org.esa.beam.dataio.netcdf.util.ScaledVariable;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class HdfEosBandPart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        ScaledVariable[] scaledVariables;
        Variable[] variables;
        RasterDigest rasterDigest = ctx.getRasterDigest();
        for (Variable variable : variables = rasterDigest.getRasterVariables()) {
            int rasterDataType = DataTypeUtils.getRasterDataType(variable);
            Band band = p.addBand(variable.getShortName(), rasterDataType);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)band);
            band.setSourceImage((MultiLevelImage)new NetcdfMultiLevelImage((RasterDataNode)band, variable, ctx));
        }
        for (ScaledVariable scaledVariable : scaledVariables = rasterDigest.getScaledVariables()) {
            Variable variable = scaledVariable.getVariable();
            int rasterDataType = DataTypeUtils.getRasterDataType(variable);
            Band band = p.addBand(variable.getShortName(), rasterDataType);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)band);
            band.setSourceImage((MultiLevelImage)new ScaledMultiLevelImage((RasterDataNode)band, scaledVariable, ctx));
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        throw new IllegalStateException();
    }

    private static class ScaledMultiLevelImage
    extends AbstractNetcdfMultiLevelImage {
        private final Variable variable;
        private final float scaleFactor;
        private final int[] imageOrigin;
        private final ProfileReadContext ctx;

        public ScaledMultiLevelImage(RasterDataNode rdn, ScaledVariable scaledVariable, ProfileReadContext ctx) {
            super(rdn);
            this.variable = scaledVariable.getVariable();
            this.scaleFactor = scaledVariable.getScaleFactor();
            this.imageOrigin = new int[0];
            this.ctx = ctx;
        }

        @Override
        protected RenderedImage createImage(int level) {
            RasterDataNode rdn = this.getRasterDataNode();
            NetcdfFile lock = this.ctx.getNetcdfFile();
            Object object = this.ctx.getProperty("yFlipped");
            boolean isYFlipped = object instanceof Boolean && (Boolean)object != false;
            int dataBufferType = ImageManager.getDataBufferType((int)rdn.getDataType());
            int sourceWidth = (int)((float)rdn.getSceneRasterWidth() / this.scaleFactor);
            int sourceHeight = (int)((float)rdn.getSceneRasterHeight() / this.scaleFactor);
            ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level);
            Dimension imageTileSize = new Dimension(this.getTileWidth(), this.getTileHeight());
            Object netcdfImg = this.variable.getDataType() == DataType.LONG ? (rdn.getName().endsWith("_lsb") ? NetcdfOpImage.createLsbImage(this.variable, this.imageOrigin, isYFlipped, lock, dataBufferType, sourceWidth, sourceHeight, imageTileSize, resolutionLevel) : NetcdfOpImage.createMsbImage(this.variable, this.imageOrigin, isYFlipped, lock, dataBufferType, sourceWidth, sourceHeight, imageTileSize, resolutionLevel)) : new NetcdfOpImage(this.variable, this.imageOrigin, isYFlipped, lock, dataBufferType, sourceWidth, sourceHeight, imageTileSize, resolutionLevel);
            return ScaleDescriptor.create((RenderedImage)netcdfImg, (Float)Float.valueOf(this.scaleFactor), (Float)Float.valueOf(this.scaleFactor), (Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.5f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
    }
}

