/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos;

import java.io.IOException;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.ProfileWriteContext;
import org.esa.beam.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos.HdfEosUtils;
import org.esa.beam.dataio.netcdf.util.TimeUtils;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.jdom2.Element;

public class HdfEosTimePart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        Element element = (Element)ctx.getProperty("CoreMetadata");
        if (element != null) {
            p.setStartTime(this.readEosTime(element, "RANGEBEGINNINGDATE", "RANGEBEGINNINGTIME"));
            p.setEndTime(this.readEosTime(element, "RANGEENDINGDATE", "RANGEENDINGTIME"));
        }
    }

    private ProductData.UTC readEosTime(Element element, String dateElemName, String timeElemName) {
        String date = HdfEosUtils.getValue(element, "INVENTORYMETADATA", "MASTERGROUP", "RANGEDATETIME", dateElemName, "VALUE");
        String time = HdfEosUtils.getValue(element, "INVENTORYMETADATA", "MASTERGROUP", "RANGEDATETIME", timeElemName, "VALUE");
        if (date != null && !date.isEmpty() && time != null && !time.isEmpty()) {
            return TimeUtils.parseDateTime(date + " " + time);
        }
        return null;
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        throw new IllegalStateException();
    }
}

