/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.metadata.profiles.hdfeos;

import java.io.IOException;
import java.util.StringTokenizer;
import org.jdom2.Element;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf4.ODLparser;

public class HdfEosUtils {
    static final String STRUCT_METADATA = "StructMetadata";
    static final String CORE_METADATA = "CoreMetadata";
    static final String ARCHIVE_METADATA = "ArchiveMetadata";

    public static Element getEosElement(String name, Group eosGroup) throws IOException {
        String smeta = HdfEosUtils.getEosMetadata(name, eosGroup);
        if (smeta == null) {
            return null;
        }
        smeta = smeta.replaceAll("\\s+=\\s+", "=");
        smeta = smeta.replaceAll("\\?", "_");
        StringBuilder sb = new StringBuilder(smeta.length());
        StringTokenizer lineFinder = new StringTokenizer(smeta, "\t\n\r\f");
        while (lineFinder.hasMoreTokens()) {
            String line = lineFinder.nextToken().trim();
            sb.append(line);
            sb.append("\n");
        }
        ODLparser parser = new ODLparser();
        return parser.parseFromString(sb.toString());
    }

    private static String getEosMetadata(String name, Group eosGroup) throws IOException {
        Variable structMetadataVar;
        StringBuilder sbuff = null;
        String structMetadata = null;
        int n = 0;
        while ((structMetadataVar = eosGroup.findVariable(name + "." + n)) != null) {
            if (structMetadata != null && sbuff == null) {
                sbuff = new StringBuilder(64000);
                sbuff.append(structMetadata);
            }
            Array metadataArray = structMetadataVar.read();
            structMetadata = ((ArrayChar)metadataArray).getString();
            if (sbuff != null) {
                sbuff.append(structMetadata);
            }
            ++n;
        }
        return sbuff != null ? sbuff.toString() : structMetadata;
    }

    static Group findGroupNested(Group parent, String name) {
        for (Group g : parent.getGroups()) {
            if (!g.getShortName().equals(name)) continue;
            return g;
        }
        for (Group g : parent.getGroups()) {
            Group result = HdfEosUtils.findGroupNested(g, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static String getValue(Element root, String ... childs) {
        String childName;
        Element element;
        int index = 0;
        for (element = root; element != null && index < childs.length; element = element.getChild(childName)) {
            childName = childs[index++];
        }
        return element != null ? element.getValue() : null;
    }
}

