/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import org.esa.beam.dataio.netcdf.ProfileReadContext;
import org.esa.beam.dataio.netcdf.util.AbstractNetcdfMultiLevelImage;
import org.esa.beam.dataio.netcdf.util.NetcdfOpImage;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetcdfMultiLevelImage
extends AbstractNetcdfMultiLevelImage {
    private final Variable variable;
    private final int[] imageOrigin;
    private final ProfileReadContext ctx;

    public NetcdfMultiLevelImage(RasterDataNode rdn, Variable variable, ProfileReadContext ctx) {
        this(rdn, variable, new int[0], ctx);
    }

    public NetcdfMultiLevelImage(RasterDataNode rdn, Variable variable, int[] imageOrigin, ProfileReadContext ctx) {
        super(rdn);
        this.variable = variable;
        this.imageOrigin = (int[])imageOrigin.clone();
        this.ctx = ctx;
    }

    @Override
    protected RenderedImage createImage(int level) {
        RasterDataNode rdn = this.getRasterDataNode();
        NetcdfFile lock = this.ctx.getNetcdfFile();
        Object object = this.ctx.getProperty("yFlipped");
        boolean isYFlipped = object instanceof Boolean && (Boolean)object != false;
        int dataBufferType = ImageManager.getDataBufferType((int)rdn.getDataType());
        int sceneRasterWidth = rdn.getSceneRasterWidth();
        int sceneRasterHeight = rdn.getSceneRasterHeight();
        ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level);
        Dimension imageTileSize = new Dimension(this.getTileWidth(), this.getTileHeight());
        if (this.variable.getDataType() == DataType.LONG) {
            if (rdn.getName().endsWith("_lsb")) {
                return NetcdfOpImage.createLsbImage(this.variable, this.imageOrigin, isYFlipped, lock, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel);
            }
            return NetcdfOpImage.createMsbImage(this.variable, this.imageOrigin, isYFlipped, lock, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel);
        }
        return new NetcdfOpImage(this.variable, this.imageOrigin, isYFlipped, lock, dataBufferType, sceneRasterWidth, sceneRasterHeight, imageTileSize, resolutionLevel);
    }
}

