/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.beam.dataio.netcdf.util.DataTypeUtils;
import org.esa.beam.dataio.netcdf.util.DimKey;
import org.esa.beam.dataio.netcdf.util.ScaledVariable;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;

public class RasterDigest {
    private final DimKey rasterDim;
    private final Variable[] variables;
    private ScaledVariable[] scaledVariables;

    public RasterDigest(DimKey rasterDim, Variable[] variables) {
        this(rasterDim, variables, new ScaledVariable[0]);
    }

    public RasterDigest(DimKey rasterDim, Variable[] variables, ScaledVariable[] scaledVariables) {
        this.rasterDim = rasterDim;
        this.variables = variables;
        this.scaledVariables = scaledVariables;
    }

    public DimKey getRasterDim() {
        return this.rasterDim;
    }

    public Variable[] getRasterVariables() {
        return this.variables;
    }

    public ScaledVariable[] getScaledVariables() {
        return this.scaledVariables;
    }

    public static RasterDigest createRasterDigest(Group ... groups) {
        HashMap<DimKey, List<Variable>> variableListMap = new HashMap<DimKey, List<Variable>>();
        for (Group group : groups) {
            RasterDigest.collectVariableLists(group, variableListMap);
        }
        if (variableListMap.isEmpty()) {
            return null;
        }
        DimKey rasterDim = RasterDigest.getBestRasterDim(variableListMap);
        Variable[] rasterVariables = RasterDigest.getRasterVariables(variableListMap, rasterDim);
        ScaledVariable[] scaledVariables = RasterDigest.getScaledVariables(variableListMap, rasterDim);
        return new RasterDigest(rasterDim, rasterVariables, scaledVariables);
    }

    private static ScaledVariable[] getScaledVariables(Map<DimKey, List<Variable>> variableListMap, DimKey rasterDim) {
        ArrayList<ScaledVariable> scaledVariableList = new ArrayList<ScaledVariable>();
        for (DimKey dimKey : variableListMap.keySet()) {
            if (dimKey.equals(rasterDim)) continue;
            double scaleX = RasterDigest.getScale(dimKey.getDimensionX(), rasterDim.getDimensionX());
            double scaleY = RasterDigest.getScale(dimKey.getDimensionY(), rasterDim.getDimensionY());
            if (scaleX != (double)Math.round(scaleX) || scaleX != scaleY) continue;
            List<Variable> variableList = variableListMap.get(dimKey);
            for (Variable variable : variableList) {
                scaledVariableList.add(new ScaledVariable((float)scaleX, variable));
            }
        }
        return scaledVariableList.toArray(new ScaledVariable[scaledVariableList.size()]);
    }

    private static double getScale(Dimension scaledDim, Dimension rasterDim) {
        double length = scaledDim.getLength();
        double rasterLength = rasterDim.getLength();
        return rasterLength / length;
    }

    static Variable[] getRasterVariables(Map<DimKey, List<Variable>> variableLists, DimKey rasterDim) {
        List<Variable> list = variableLists.get(rasterDim);
        return list.toArray(new Variable[list.size()]);
    }

    static DimKey getBestRasterDim(Map<DimKey, List<Variable>> variableListMap) {
        Set<DimKey> ncRasterDims = variableListMap.keySet();
        if (ncRasterDims.size() == 0) {
            return null;
        }
        DimKey bestRasterDim = null;
        List<Variable> bestVarList = null;
        for (DimKey rasterDim : ncRasterDims) {
            if (rasterDim.isTypicalRasterDim()) {
                return rasterDim;
            }
            List<Variable> varList = variableListMap.get(rasterDim);
            if (bestVarList != null && varList.size() <= bestVarList.size()) continue;
            bestRasterDim = rasterDim;
            bestVarList = varList;
        }
        return bestRasterDim;
    }

    static void collectVariableLists(Group group, Map<DimKey, List<Variable>> variableLists) {
        List variables = group.getVariables();
        for (Variable variable : variables) {
            int rank = variable.getRank();
            if (rank < 2 || !DataTypeUtils.isValidRasterDataType(variable.getDataType()) && variable.getDataType() != DataType.LONG) continue;
            DimKey rasterDim = new DimKey(variable.getDimensions().toArray(new Dimension[variable.getDimensions().size()]));
            Dimension dimX = rasterDim.getDimensionX();
            Dimension dimY = rasterDim.getDimensionY();
            if (dimX.getLength() <= 1 || dimY.getLength() <= 1) continue;
            List<Variable> list = variableLists.get(rasterDim);
            if (list == null) {
                list = new ArrayList<Variable>();
                variableLists.put(rasterDim, list);
            }
            list.add(variable);
        }
        List subGroups = group.getGroups();
        for (Group subGroup : subGroups) {
            RasterDigest.collectVariableLists(subGroup, variableLists);
        }
    }
}

