/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import java.util.List;
import org.esa.beam.dataio.netcdf.util.Constants;
import org.esa.beam.dataio.netcdf.util.VariableNameHelper;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3iosp;

public class ReaderUtils {
    public static ProductData createProductData(int productDataType, Array values) {
        Object data = values.getStorage();
        if (data instanceof char[]) {
            data = new String((char[])data);
        }
        return ProductData.createInstance((int)productDataType, (Object)data);
    }

    public static boolean hasValidExtension(String pathname) {
        String[] validExtensions;
        String lowerPath = pathname.toLowerCase();
        for (String validExtension : validExtensions = Constants.FILE_EXTENSIONS) {
            if (!lowerPath.endsWith(validExtension = validExtension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static Variable[] getVariables(List<Variable> variables, String[] names) {
        if (variables == null || names == null) {
            return null;
        }
        if (variables.size() < names.length) {
            return null;
        }
        Variable[] result = new Variable[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            for (Variable variable : variables) {
                if (!variable.getFullName().equalsIgnoreCase(name)) continue;
                result[i] = variable;
                break;
            }
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    public static String getRasterName(Variable variable) {
        Attribute attribute = variable.findAttribute("orig_name");
        if (attribute != null) {
            return attribute.getStringValue();
        }
        return variable.getFullName();
    }

    public static String getVariableName(RasterDataNode rasterDataNode) {
        String name = N3iosp.makeValidNetcdfObjectName((String)rasterDataNode.getName());
        if (!VariableNameHelper.isVariableNameValid(name = name.replace('.', '_'))) {
            name = VariableNameHelper.convertToValidName(name);
        }
        return name;
    }
}

