/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.netcdf.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class VariableMap {
    private final Map<String, Variable> map;

    public VariableMap(int initialCapacity) {
        this.map = new HashMap<String, Variable>(initialCapacity);
    }

    public VariableMap(Variable[] variables) {
        this(3 * variables.length / 2 + 1);
        for (Variable variable : variables) {
            this.put(variable);
        }
    }

    private VariableMap(List<Variable> variables) {
        this(variables.toArray(new Variable[variables.size()]));
    }

    public static VariableMap create(NetcdfFile file) {
        return new VariableMap(file.getVariables());
    }

    public static VariableMap create(Group group) {
        return new VariableMap(group.getVariables());
    }

    public Variable get(String name) {
        return this.map.get(name);
    }

    public void put(Variable variable) {
        this.map.put(VariableMap.getAbsoluteName(variable), variable);
    }

    public void put(String name, Variable variable) {
        this.map.put(name, variable);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public static String getAbsoluteName(Variable variable) {
        return variable.getFullName();
    }
}

