/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.measurement.Measurement;

public class PixExMeasurementReader
implements Iterator<Measurement>,
Closeable {
    private int readerIndex;
    private boolean withExpression;
    private BufferedReader[] bufferedReaders;
    private String measurementLine;
    private File inputDir;
    private AtomicBoolean isInitialzed;

    public PixExMeasurementReader(File inputDir) {
        this.inputDir = inputDir;
        this.readerIndex = 0;
        this.isInitialzed = new AtomicBoolean(false);
    }

    private void initialize(File inputDir) {
        try {
            this.bufferedReaders = this.initReader(inputDir.listFiles(new MeasurementFilenameFilter()));
            this.measurementLine = this.getNextMeasurementLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedReader[] initReader(File[] measurementFiles) throws IOException {
        BufferedReader[] readers = new BufferedReader[measurementFiles.length];
        for (int i = 0; i < measurementFiles.length; ++i) {
            File measurementFile = measurementFiles[i];
            readers[i] = new BufferedReader(new FileReader(measurementFile));
            String line = readers[i].readLine();
            while (line.startsWith("#") || line.isEmpty()) {
                line = readers[i].readLine();
            }
            this.withExpression = line.toLowerCase().startsWith("expression");
        }
        return readers;
    }

    @Override
    public boolean hasNext() {
        if (this.isInitialzed.compareAndSet(false, true)) {
            this.initialize(this.inputDir);
        }
        return this.measurementLine != null;
    }

    @Override
    public Measurement next() {
        if (this.isInitialzed.compareAndSet(false, true)) {
            this.initialize(this.inputDir);
        }
        if (this.measurementLine == null) {
            throw new NoSuchElementException("No more measurements.");
        }
        Measurement measurement = PixExMeasurementReader.readMeasurement(this.measurementLine, this.withExpression);
        this.measurementLine = this.getNextMeasurementLine();
        return measurement;
    }

    static Measurement readMeasurement(String line, boolean withExpression) {
        Scanner scanner = new Scanner(line);
        scanner.useLocale(Locale.ENGLISH);
        scanner.useDelimiter("\t");
        boolean isValid = true;
        if (withExpression) {
            isValid = scanner.nextBoolean();
        }
        int productId = scanner.nextInt();
        int coordId = scanner.nextInt();
        String name = scanner.next();
        float lat = scanner.nextFloat();
        float lon = scanner.nextFloat();
        float pixelX = scanner.nextFloat();
        float pixelY = scanner.nextFloat();
        String date = scanner.next().trim();
        String time = scanner.next().trim();
        ProductData.UTC dateTime = null;
        if (!date.isEmpty() && !time.isEmpty()) {
            try {
                dateTime = ProductData.UTC.parse((String)(date + " " + time), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Double> valueList = new ArrayList<Double>();
        while (scanner.hasNext()) {
            if (scanner.hasNextDouble()) {
                valueList.add(scanner.nextDouble());
                continue;
            }
            String next = scanner.next().trim();
            if (!next.isEmpty()) continue;
            valueList.add(Double.NaN);
        }
        Object[] values = valueList.toArray(new Number[valueList.size()]);
        return new Measurement(coordId, name, productId, pixelX, pixelY, dateTime, new GeoPos(lat, lon), values, isValid);
    }

    private String getNextMeasurementLine() {
        String line;
        block6: {
            if (this.bufferedReaders == null || this.bufferedReaders.length == 0) {
                return null;
            }
            BufferedReader reader = this.bufferedReaders[this.readerIndex];
            try {
                line = reader.readLine();
                if (line != null) break block6;
                try {
                    reader.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                if (++this.readerIndex < this.bufferedReaders.length) {
                    reader = this.bufferedReaders[this.readerIndex];
                    line = reader.readLine();
                }
            }
            catch (IOException ignored) {
                return null;
            }
        }
        return line;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.isInitialzed.get()) {
            for (BufferedReader bufferedReader : this.bufferedReaders) {
                bufferedReader.close();
            }
        }
    }

    private static class MeasurementFilenameFilter
    implements FilenameFilter {
        private MeasurementFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith("measurements.txt");
        }
    }
}

