/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.aggregators;

import org.esa.beam.pixex.aggregators.AggregatorStrategy;
import org.esa.beam.pixex.calvalus.ma.AggregatedNumber;
import org.esa.beam.pixex.calvalus.ma.DefaultRecord;
import org.esa.beam.pixex.calvalus.ma.Record;
import org.esa.beam.pixex.calvalus.ma.RecordAggregator;

abstract class AbstractAggregatorStrategy
implements AggregatorStrategy {
    static final String NUM_PIXELS_SUFFIX = "num_pixels";

    AbstractAggregatorStrategy() {
    }

    @Override
    public int getValueCount() {
        return this.getSuffixes().length;
    }

    protected AggregatedNumber getAggregatedNumber(Record record, int rasterIndex) {
        RecordAggregator recordAggregator = new RecordAggregator(-1, -1.0);
        Number[][] attributeValues = (Number[][])record.getAttributeValues();
        Object[] newAttributeValues = new Object[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            Number[] attributeValue = attributeValues[i];
            newAttributeValues[i] = attributeValue instanceof Float[] ? (Object)this.toPrimitiveArray((Float[])attributeValue) : (Object)this.toPrimitiveArray((Integer[])attributeValue);
        }
        DefaultRecord defaultRecord = new DefaultRecord(record.getLocation(), record.getTime(), newAttributeValues);
        Record transformedRecord = recordAggregator.transform(defaultRecord);
        return (AggregatedNumber)transformedRecord.getAttributeValues()[rasterIndex];
    }

    private int[] toPrimitiveArray(Integer[] attributeValue) {
        int[] result = new int[attributeValue.length];
        for (int i = 0; i < attributeValue.length; ++i) {
            result[i] = attributeValue[i];
        }
        return result;
    }

    private float[] toPrimitiveArray(Float[] attributeValue) {
        float[] result = new float[attributeValue.length];
        for (int i = 0; i < attributeValue.length; ++i) {
            result[i] = attributeValue[i].floatValue();
        }
        return result;
    }
}

