/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.aggregators;

import java.util.Arrays;
import org.esa.beam.pixex.aggregators.AbstractAggregatorStrategy;
import org.esa.beam.pixex.calvalus.ma.Record;

public class MedianAggregatorStrategy
extends AbstractAggregatorStrategy {
    @Override
    public Number[] getValues(Record record, int rasterIndex) {
        float median = this.getMedian((Number[])record.getAttributeValues()[rasterIndex]);
        return new Number[]{Float.valueOf(median), this.getAggregatedNumber((Record)record, (int)rasterIndex).nT};
    }

    @Override
    public String[] getSuffixes() {
        return new String[]{"median", "num_pixels"};
    }

    float getMedian(Number[] bandValues) {
        if (bandValues == null || bandValues.length == 0) {
            return Float.NaN;
        }
        Object[] values = (Number[])bandValues.clone();
        Arrays.sort(values);
        if (values.length % 2 == 1) {
            return ((Number)values[values.length / 2]).floatValue();
        }
        float leftMedian = ((Number)values[values.length / 2 - 1]).floatValue();
        float rightMedian = ((Number)values[values.length / 2]).floatValue();
        return (leftMedian + rightMedian) / 2.0f;
    }
}

