/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.calvalus.ma;

public final class AggregatedNumber
extends Number {
    public final int n;
    public final int nT;
    public final int nF;
    public final double min;
    public final double max;
    public final double mean;
    public final double sigma;
    public final double cv;
    public final float[] data;

    public AggregatedNumber(int n, int nT, int nF, double min, double max, double mean, double sigma) {
        this(n, nT, nF, min, max, mean, sigma, null);
    }

    public AggregatedNumber(int n, int nT, int nF, double min, double max, double mean, double sigma, float[] data) {
        this.nT = nT;
        this.min = min;
        this.max = max;
        this.n = n;
        this.nF = nF;
        this.mean = mean;
        this.sigma = sigma;
        this.cv = sigma / mean;
        this.data = data;
    }

    @Override
    public int intValue() {
        return (int)Math.round(this.mean);
    }

    @Override
    public long longValue() {
        return Math.round(this.mean);
    }

    @Override
    public float floatValue() {
        return (float)this.mean;
    }

    @Override
    public double doubleValue() {
        return this.mean;
    }

    public String toString() {
        return String.valueOf(this.floatValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedNumber that = (AggregatedNumber)o;
        if (Double.compare(that.max, this.max) != 0) {
            return false;
        }
        if (Double.compare(that.mean, this.mean) != 0) {
            return false;
        }
        if (Double.compare(that.min, this.min) != 0) {
            return false;
        }
        if (this.n != that.n) {
            return false;
        }
        if (this.nF != that.nF) {
            return false;
        }
        if (this.nT != that.nT) {
            return false;
        }
        return Double.compare(that.sigma, this.sigma) == 0;
    }

    public int hashCode() {
        int result = this.n;
        result = 31 * result + this.nT;
        result = 31 * result + this.nF;
        long temp = this.min != 0.0 ? Double.doubleToLongBits(this.min) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.max != 0.0 ? Double.doubleToLongBits(this.max) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.mean != 0.0 ? Double.doubleToLongBits(this.mean) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.sigma != 0.0 ? Double.doubleToLongBits(this.sigma) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

