/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.calvalus.ma;

import java.lang.reflect.Array;
import org.esa.beam.pixex.calvalus.ma.AggregatedNumber;
import org.esa.beam.pixex.calvalus.ma.DefaultRecord;
import org.esa.beam.pixex.calvalus.ma.Record;
import org.esa.beam.pixex.calvalus.ma.RecordTransformer;

public class RecordAggregator
implements RecordTransformer {
    private final int maskAttributeIndex;
    private final double filteredMeanCoeff;

    public RecordAggregator(int maskAttributeIndex, double filteredMeanCoeff) {
        this.maskAttributeIndex = maskAttributeIndex;
        this.filteredMeanCoeff = filteredMeanCoeff;
    }

    @Override
    public Record transform(Record record) {
        Object[] attributeValues = record.getAttributeValues();
        int length = RecordAggregator.getCommonArrayValueLength(attributeValues);
        if (length == -1) {
            return record;
        }
        int[] maskValues = this.getMaskValues(attributeValues);
        Object[] aggregatedValues = new Object[attributeValues.length];
        for (int valueIndex = 0; valueIndex < aggregatedValues.length; ++valueIndex) {
            Object attributeValue = attributeValues[valueIndex];
            if (attributeValue != null && attributeValue == maskValues) {
                attributeValue = this.aggregate(maskValues, (int[])null);
            } else if (attributeValue instanceof float[]) {
                attributeValue = this.aggregate((float[])attributeValue, maskValues);
            } else if (attributeValue instanceof int[]) {
                attributeValue = this.aggregate((int[])attributeValue, maskValues);
            }
            aggregatedValues[valueIndex] = attributeValue;
        }
        return new DefaultRecord(record.getLocation(), record.getTime(), aggregatedValues);
    }

    private int[] getMaskValues(Object[] attributeValues) {
        if (this.maskAttributeIndex != -1) {
            return (int[])attributeValues[this.maskAttributeIndex];
        }
        return null;
    }

    private Number aggregate(int[] values, int[] maskValues) {
        if (values.length == 1) {
            return RecordAggregator.isGoodPixel(maskValues, 0) ? Integer.valueOf(values[0]) : null;
        }
        float[] floats = new float[values.length];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = values[i];
        }
        return this.aggregate(floats, maskValues);
    }

    private Number aggregate(float[] values, int[] maskValues) {
        double sigma;
        if (values.length == 1) {
            return Float.valueOf(RecordAggregator.isGoodPixel(maskValues, 0) ? values[0] : Float.NaN);
        }
        double sum = 0.0;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int numGoodPixels = 0;
        int numTotalPixels = 0;
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (Float.isNaN(value)) continue;
            ++numTotalPixels;
            if (!RecordAggregator.isGoodPixel(maskValues, i)) continue;
            ++numGoodPixels;
            sum += (double)value;
            min = Math.min(min, (double)value);
            max = Math.max(max, (double)value);
        }
        double mean = numGoodPixels > 0 ? sum / (double)numGoodPixels : Double.NaN;
        double sumSigma = 0.0;
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (Float.isNaN(value) || !RecordAggregator.isGoodPixel(maskValues, i)) continue;
            sumSigma += (mean - (double)value) * (mean - (double)value);
        }
        double d = sigma = numGoodPixels > 1 ? Math.sqrt(sumSigma / (double)(numGoodPixels - 1)) : 0.0;
        if (this.filteredMeanCoeff <= 0.0 || Math.abs(sigma) < 1.0E-10) {
            return new AggregatedNumber(numGoodPixels, numTotalPixels, 0, min, max, mean, sigma, values);
        }
        double lowerBound = mean - this.filteredMeanCoeff * sigma;
        double upperBound = mean + this.filteredMeanCoeff * sigma;
        numGoodPixels = 0;
        int numFilteredPixels = 0;
        double filteredSum = 0.0;
        double filteredMin = Double.MAX_VALUE;
        double filteredMax = -1.7976931348623157E308;
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (Float.isNaN(value) || !RecordAggregator.isGoodPixel(maskValues, i)) continue;
            if ((double)value >= lowerBound && (double)value <= upperBound) {
                filteredSum += (double)value;
                filteredMin = Math.min(filteredMin, (double)value);
                filteredMax = Math.max(filteredMax, (double)value);
                ++numGoodPixels;
                continue;
            }
            ++numFilteredPixels;
        }
        double filteredMean = numGoodPixels > 0 ? filteredSum / (double)numGoodPixels : Double.NaN;
        double filteredSumSigma = 0.0;
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (Float.isNaN(value) || !RecordAggregator.isGoodPixel(maskValues, i) || !((double)value > lowerBound) || !((double)value < upperBound)) continue;
            filteredSumSigma += (filteredMean - (double)value) * (filteredMean - (double)value);
        }
        double filteredSigma = numGoodPixels > 1 ? Math.sqrt(filteredSumSigma / (double)(numGoodPixels - 1)) : 0.0;
        return new AggregatedNumber(numGoodPixels, numTotalPixels, numFilteredPixels, filteredMin, filteredMax, filteredMean, filteredSigma, values);
    }

    private static boolean isGoodPixel(int[] maskValues, int i) {
        return maskValues == null || maskValues[i] != 0;
    }

    private static int getCommonArrayValueLength(Object[] attributeValues) {
        int commonLength = -1;
        for (Object attributeValue : attributeValues) {
            if (attributeValue == null || !attributeValue.getClass().isArray()) continue;
            int length = Array.getLength(attributeValue);
            if (commonLength >= 0 && length != commonLength) {
                throw new IllegalArgumentException("Record with varying array lengths detected. Expected " + commonLength + ", found " + length);
            }
            commonLength = length;
            if (attributeValue instanceof int[] || attributeValue instanceof float[]) continue;
            throw new IllegalArgumentException("Records with array values can only be of type int[] or float[].");
        }
        if (commonLength == 0) {
            throw new IllegalArgumentException("Record with zero-length arrays.");
        }
        return commonLength;
    }
}

