/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.output;

import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.measurement.Measurement;
import org.esa.beam.measurement.writer.MeasurementFactory;
import org.esa.beam.util.ProductUtils;

public abstract class AbstractMeasurementFactory
implements MeasurementFactory {
    protected static Measurement createMeasurement(Product product, long productId, int coordinateID, String coordinateName, Number[] values, boolean isValid, int x, int y) {
        PixelPos pixelPos = new PixelPos((float)x + 0.5f, (float)y + 0.5f);
        GeoCoding geoCoding = product.getGeoCoding();
        GeoPos currentGeoPos = geoCoding != null ? geoCoding.getGeoPos(pixelPos, null) : new GeoPos();
        ProductData.UTC scanLineTime = ProductUtils.getScanLineTime((Product)product, (double)pixelPos.y);
        return new Measurement(coordinateID, coordinateName, productId, pixelPos.x, pixelPos.y, scanLineTime, currentGeoPos, values, isValid);
    }

    protected static void setBandValues(Product product, String[] rasterNames, int x, int y, Number[] bandValues) {
        for (int i = 0; i < rasterNames.length; ++i) {
            RasterDataNode raster = product.getRasterDataNode(rasterNames[i]);
            if (raster == null || !product.containsPixel((float)x, (float)y)) continue;
            if (AbstractMeasurementFactory.pixelIsNotInBounds(raster, x, y) || !raster.isPixelValid(x, y)) {
                bandValues[i] = Double.NaN;
                continue;
            }
            if (raster.isFloatingPointType()) {
                bandValues[i] = (double)raster.getSampleFloat(x, y);
                continue;
            }
            int temp = raster.getSampleInt(x, y);
            bandValues[i] = raster instanceof Mask ? (Number)(temp == 0 ? 0 : 1) : (Number)(raster.getDataType() == 22 ? (Number)((long)temp & 0xFFFFL) : (Number)temp);
        }
    }

    private static boolean pixelIsNotInBounds(RasterDataNode raster, int x, int y) {
        int height = raster.getSceneRasterHeight();
        int width = raster.getSceneRasterWidth();
        return x < 0 || x >= width || y < 0 || y >= height;
    }
}

