/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.output;

import java.awt.image.Raster;
import java.io.IOException;
import java.util.Arrays;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.measurement.Measurement;
import org.esa.beam.pixex.aggregators.AggregatorStrategy;
import org.esa.beam.pixex.calvalus.ma.DefaultRecord;
import org.esa.beam.pixex.output.AbstractMeasurementFactory;
import org.esa.beam.pixex.output.ProductRegistry;
import org.esa.beam.pixex.output.RasterNamesFactory;

public class AggregatingPixExMeasurementFactory
extends AbstractMeasurementFactory {
    private final RasterNamesFactory rasterNamesFactory;
    private final int windowSize;
    private final ProductRegistry productRegistry;
    private final AggregatorStrategy aggregatorStrategy;

    public AggregatingPixExMeasurementFactory(RasterNamesFactory rasterNamesFactory, int windowSize, ProductRegistry productRegistry, AggregatorStrategy aggregatorStrategy) {
        this.rasterNamesFactory = rasterNamesFactory;
        this.windowSize = windowSize;
        this.productRegistry = productRegistry;
        this.aggregatorStrategy = aggregatorStrategy;
    }

    @Override
    public Measurement[] createMeasurements(int pixelX, int pixelY, int coordinateID, String coordinateName, Product product, Raster validData) throws IOException {
        long productId = this.productRegistry.getProductId(product);
        int numPixels = this.windowSize * this.windowSize;
        Measurement[] measurements = new Measurement[1];
        String[] rasterNames = this.rasterNamesFactory.getUniqueRasterNames(product);
        Float[][] values = new Float[rasterNames.length][numPixels];
        for (int i = 0; i < rasterNames.length; ++i) {
            String rasterName = rasterNames[i];
            Float[] bandValues = new Float[numPixels];
            Band band = product.getBand(rasterName);
            AggregatingPixExMeasurementFactory.setBandValues(product, (RasterDataNode)band, bandValues, this.windowSize, pixelX, pixelY, validData);
            values[i] = bandValues;
        }
        DefaultRecord record = new DefaultRecord((Object[])values);
        Number[] numbers = new Number[rasterNames.length * this.aggregatorStrategy.getValueCount()];
        for (int i = 0; i < rasterNames.length; ++i) {
            Number[] valuesForBand = this.aggregatorStrategy.getValues(record, i);
            for (int j = 0; j < this.aggregatorStrategy.getValueCount(); ++j) {
                Number v;
                numbers[i * this.aggregatorStrategy.getValueCount() + j] = v = valuesForBand[j];
            }
        }
        measurements[0] = AggregatingPixExMeasurementFactory.createMeasurement(product, productId, coordinateID, coordinateName, numbers, true, pixelX, pixelY);
        return measurements;
    }

    @Override
    public void close() {
        this.productRegistry.close();
    }

    private static void setBandValues(Product product, RasterDataNode raster, Float[] bandValues, int windowSize, int pixelX, int pixelY, Raster validData) {
        int windowBorder = windowSize / 2;
        if (raster == null) {
            Arrays.fill((Object[])bandValues, Float.valueOf(Float.NaN));
            return;
        }
        int pixelIndex = 0;
        for (int x = pixelX - windowBorder; x <= pixelX + windowBorder; ++x) {
            for (int y = pixelY - windowBorder; y <= pixelY + windowBorder; ++y) {
                if (product.containsPixel((float)x, (float)y)) {
                    if (!raster.isPixelValid(x, y) || validData != null && validData.getSample(x, y, 0) == 0) {
                        bandValues[pixelIndex] = Float.valueOf(Float.NaN);
                    } else if (raster.isFloatingPointType()) {
                        float sampleFloat = raster.getSampleFloat(x, y);
                        bandValues[pixelIndex] = Float.valueOf(AggregatingPixExMeasurementFactory.isNoDataValue(raster, sampleFloat) ? Float.NaN : sampleFloat);
                    } else {
                        int temp = raster.getSampleInt(x, y);
                        bandValues[pixelIndex] = raster instanceof Mask ? Float.valueOf(temp != 0 ? 1 : 0) : (raster.getDataType() == 22 ? (AggregatingPixExMeasurementFactory.isNoDataValue(raster, temp) ? Float.valueOf(Float.NaN) : Float.valueOf((long)temp & 0xFFFFL)) : (AggregatingPixExMeasurementFactory.isNoDataValue(raster, temp) ? Float.valueOf(Float.NaN) : Float.valueOf(temp)));
                    }
                }
                ++pixelIndex;
            }
        }
    }

    private static boolean isNoDataValue(RasterDataNode raster, int sample) {
        return !raster.isNoDataValueUsed() && (double)sample == raster.getNoDataValue();
    }

    private static boolean isNoDataValue(RasterDataNode raster, float sample) {
        return !raster.isNoDataValueUsed() && (double)sample == raster.getNoDataValue();
    }
}

