/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.output;

import java.io.PrintWriter;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.measurement.Measurement;
import org.esa.beam.pixex.output.AbstractFormatStrategy;
import org.esa.beam.pixex.output.RasterNamesFactory;

public class DefaultFormatStrategy
extends AbstractFormatStrategy {
    public DefaultFormatStrategy(RasterNamesFactory rasterNamesFactory, int windowSize, String expression, boolean exportExpressionResult) {
        super(rasterNamesFactory, expression, windowSize, exportExpressionResult);
    }

    @Override
    public void writeHeader(PrintWriter writer, Product product) {
        this.writeStandardHeader(writer);
        this.writeWavelengthLine(writer, product);
        this.writeStandardColumnNames(writer);
        this.writeRasterNames(writer, product);
        writer.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMeasurements(Product product, PrintWriter writer, Measurement[] measurements) {
        try {
            for (Measurement measurement : measurements) {
                this.write(writer, measurement);
            }
        }
        finally {
            writer.flush();
        }
    }

    private void write(PrintWriter writer, Measurement measurement) {
        if (this.expression == null || this.exportExpressionResult || measurement.isValid()) {
            boolean withExpression = this.expression != null && this.exportExpressionResult;
            this.writeLine(writer, measurement, withExpression);
            writer.write("\n");
        }
    }
}

