/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.pixex.output;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.measurement.Measurement;
import org.esa.beam.pixex.output.AbstractFormatStrategy;
import org.esa.beam.pixex.output.RasterNamesFactory;

public class MatchupFormatStrategy
extends AbstractFormatStrategy {
    final Measurement[] originalMeasurements;
    private HashMap<String, Integer> attributeIndices = new HashMap();

    public MatchupFormatStrategy(Measurement[] originalMeasurements, RasterNamesFactory rasterNamesFactory, int windowSize, String expression, boolean exportExpressionResult) {
        super(rasterNamesFactory, expression, windowSize, exportExpressionResult);
        this.originalMeasurements = originalMeasurements;
    }

    @Override
    public void writeHeader(PrintWriter writer, Product product) {
        this.writeStandardHeader(writer);
        this.writeWavelengthLine(writer, product);
        this.writeOriginalMeasurementsColumns(writer);
        this.writeStandardColumnNames(writer);
        this.writeRasterNames(writer, product);
        writer.println();
    }

    private void writeOriginalMeasurementsColumns(PrintWriter writer) {
        List<String> originalAttributeNames = this.getOriginalAttributeNames();
        for (String attributeName : originalAttributeNames) {
            writer.write(attributeName + "\t");
        }
    }

    @Override
    public void writeMeasurements(Product product, PrintWriter writer, Measurement[] measurements) {
        for (Measurement measurement : measurements) {
            boolean withExpression;
            Measurement matchingMeasurement = MatchupFormatStrategy.findMatchingMeasurement(measurement, this.originalMeasurements);
            boolean bl = withExpression = this.expression != null && this.exportExpressionResult;
            if (this.expression != null && !this.exportExpressionResult && !measurement.isValid()) continue;
            for (int i = 0; i < this.getOriginalAttributeNames().size(); ++i) {
                for (int j = 0; j < matchingMeasurement.getOriginalAttributeNames().length; ++j) {
                    String originalAttributeName = matchingMeasurement.getOriginalAttributeNames()[j];
                    Integer index = this.attributeIndices.get(originalAttributeName);
                    if (index != i) continue;
                    this.writeValue(writer, matchingMeasurement.getValues()[j]);
                }
                writer.write("\t");
            }
            this.writeLine(writer, measurement, withExpression);
            writer.write("\n");
        }
    }

    static Measurement findMatchingMeasurement(Measurement measurement, Measurement[] originalMeasurements) {
        for (Measurement currentMeasurement : originalMeasurements) {
            if (currentMeasurement.getCoordinateID() != measurement.getCoordinateID()) continue;
            return currentMeasurement;
        }
        throw new IllegalArgumentException("No matching measurement found for measurement '" + measurement.toString() + "'.");
    }

    @Override
    protected int getAttributeCount() {
        return this.getOriginalAttributeNames().size() + super.getAttributeCount();
    }

    private List<String> getOriginalAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (Measurement originalMeasurement : this.originalMeasurements) {
            for (String attributeName : originalMeasurement.getOriginalAttributeNames()) {
                if (attributeNames.contains(attributeName)) continue;
                attributeNames.add(attributeName);
                this.attributeIndices.put(attributeName, attributeNames.size() - 1);
            }
        }
        return attributeNames;
    }
}

